/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entities.spirit;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.entities.boomerang.ScytheBoomerangEntity;
import com.sammy.malum.common.items.SpiritItem;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.systems.spirits.ISpiritEntityGlow;
import com.sammy.malum.core.systems.spirits.SpiritHelper;
import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class SpiritItemEntity
extends ProjectileItemEntity {
    public static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(ScytheBoomerangEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public ItemStack stack;
    public UUID ownerUUID;
    public LivingEntity owner;
    public int age;
    public float rotation;
    public final float hoverStart;

    public SpiritItemEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70145_X = false;
        this.hoverStart = (float)(Math.random() * Math.PI * 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    public void setData(ItemStack stack, UUID ownerUUID) {
        this.stack = stack;
        this.ownerUUID = ownerUUID;
        if (MalumHelper.areWeOnServer(this.field_70170_p)) {
            this.owner = (LivingEntity)((ServerWorld)this.field_70170_p).func_217461_a(ownerUUID);
        }
        this.func_184212_Q().func_187227_b(STACK, (Object)stack);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        float rotationSpeed = 1.75f;
        float extraSpeed = 5.25f;
        float rotationTime = 160.0f;
        this.rotation += (float)this.age > rotationTime ? rotationSpeed : rotationSpeed + (rotationTime - (float)this.age) / rotationTime * extraSpeed;
        if (MalumHelper.areWeOnServer(this.field_70170_p)) {
            this.func_213317_d(this.func_213322_ci().func_216372_d((double)0.9f, (double)0.8f, (double)0.9f));
            if (this.owner != null) {
                float distance = this.func_70032_d((Entity)this.owner);
                if (this.age > 10) {
                    float minimumDistance = 2.0f;
                    float velocity = 0.25f;
                    if (MalumHelper.hasCurioEquipped(this.owner, MalumItems.RING_OF_ARCANE_REACH)) {
                        minimumDistance = 8.0f;
                        velocity = 0.4f;
                    }
                    if (distance < minimumDistance) {
                        Vector3d ownerPos = this.owner.func_213303_ch().func_72441_c(0.0, 0.0, 0.0);
                        Vector3d desiredMotion = new Vector3d(ownerPos.field_72450_a - this.func_226277_ct_(), ownerPos.field_72448_b - this.func_226278_cu_(), ownerPos.field_72449_c - this.func_226281_cx_()).func_72432_b().func_216372_d((double)velocity, (double)velocity, (double)velocity);
                        this.func_213317_d(desiredMotion);
                    }
                    if (distance < 0.5f && this.func_70089_S()) {
                        if (this.stack.func_77973_b() instanceof SpiritItem) {
                            SpiritItem spiritItem = (SpiritItem)this.stack.func_77973_b();
                            SpiritHelper.harvestSpirit(spiritItem.type.identifier, this.owner);
                        } else {
                            MalumHelper.giveItemToEntity(this.stack, this.owner);
                        }
                        this.func_70106_y();
                    }
                }
            }
        } else {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_() + (double)this.yOffset(0.0f) + 0.25;
            double z = this.func_226281_cx_();
            if (this.stack == null) {
                this.stack = (ItemStack)this.field_70180_af.func_187225_a(STACK);
            }
            if (this.stack.func_77973_b() instanceof ISpiritEntityGlow) {
                ISpiritEntityGlow entityGlow = (ISpiritEntityGlow)this.stack.func_77973_b();
                Color color = entityGlow.getColor();
                SpiritHelper.spiritParticles(this.field_70170_p, x, y, z, color);
            }
        }
    }

    public float yOffset(float partialTicks) {
        return MathHelper.func_76126_a((float)(((float)this.age + partialTicks) / 10.0f + this.hoverStart)) * 0.1f + 0.1f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("stack", (INBT)this.stack.serializeNBT());
        if (this.ownerUUID != null) {
            compound.func_186854_a("ownerUUID", this.ownerUUID);
        }
        compound.func_74768_a("age", this.age);
        compound.func_74776_a("rotation", this.rotation);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ownerUUID")) {
            this.ownerUUID = compound.func_186857_a("ownerUUID");
        }
        if (compound.func_74764_b("stack")) {
            this.stack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("stack"));
        }
        this.field_70180_af.func_187227_b(STACK, (Object)this.stack);
        this.age = compound.func_74762_e("age");
        this.rotation = compound.func_74760_g("rotation");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public float func_70111_Y() {
        return 4.0f;
    }

    protected Item func_213885_i() {
        if (this.stack == null) {
            this.stack = (ItemStack)this.field_70180_af.func_187225_a(STACK);
        }
        return this.stack.func_77973_b();
    }
}

