/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entities.boomerang;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.enchantments.MalumEnchantments;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class ScytheBoomerangEntity
extends ProjectileItemEntity {
    public static final DataParameter<ItemStack> SCYTHE = EntityDataManager.func_187226_a(ScytheBoomerangEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public ItemStack scythe;
    public UUID ownerUUID;
    public PlayerEntity owner;
    public int slot;
    public float damage;
    public int age;
    public int returnAge = 8;
    public boolean returning;

    public ScytheBoomerangEntity(EntityType<? extends ProjectileItemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70145_X = false;
    }

    public PlayerEntity owner() {
        if (this.owner == null && MalumHelper.areWeOnServer(this.field_70170_p)) {
            this.owner = (PlayerEntity)((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUUID);
        }
        return this.owner;
    }

    public void setData(float damage, UUID ownerUUID, int slot, ItemStack scythe) {
        this.damage = damage;
        this.ownerUUID = ownerUUID;
        this.slot = slot;
        this.scythe = scythe;
    }

    public void shoot(Entity playerEntity, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vector3d Vector3d2 = playerEntity.func_213322_ci();
        this.func_213317_d(this.func_213322_ci().func_72441_c(Vector3d2.field_72450_a, playerEntity.func_233570_aj_() ? 0.0 : Vector3d2.field_72448_b, Vector3d2.field_72449_c));
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vector3d motion = new Vector3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity).func_216372_d(1.0, 1.0, 1.0);
        this.func_213317_d(motion);
        float f = MathHelper.func_76133_a((double)ScytheBoomerangEntity.func_213296_b((Vector3d)motion));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)motion.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        this.returning = true;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        DamageSource source = DamageSource.func_188403_a((Entity)this, (LivingEntity)this.owner());
        Entity entity = p_213868_1_.func_216348_a();
        if (MalumHelper.areWeOnClient(this.field_70170_p)) {
            return;
        }
        if (entity.equals((Object)this.owner)) {
            super.func_213868_a(p_213868_1_);
            return;
        }
        boolean success = entity.func_70097_a(source, this.damage);
        if (success) {
            if (MalumHelper.areWeOnServer(this.field_70170_p) && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.scythe.func_222118_a(1, (LivingEntity)this.owner(), e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
                MalumHelper.applyEnchantments((LivingEntity)this.owner, (Entity)livingentity, this.scythe);
                int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.scythe);
                if (i > 0) {
                    livingentity.func_70015_d(i * 4);
                }
            }
            this.returnAge += 4;
            entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), MalumSounds.SCYTHE_STRIKE, entity.func_184176_by(), 1.0f, 0.9f + entity.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        }
        super.func_213868_a(p_213868_1_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.age;
        if (MalumHelper.areWeOnClient(this.field_70170_p) && !this.func_70090_H() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.func_184543_l()) > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
        }
        if (MalumHelper.areWeOnServer(this.field_70170_p)) {
            PlayerEntity playerEntity = this.owner();
            if (playerEntity == null) {
                return;
            }
            if (this.age % 3 == 0) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.25f);
            }
            if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
                Vector3d vector3d = this.func_213322_ci();
                float f = MathHelper.func_76133_a((double)ScytheBoomerangEntity.func_213296_b((Vector3d)vector3d));
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c) * 57.2957763671875);
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)vector3d.field_72448_b, (double)f) * 57.2957763671875);
                this.field_70126_B = this.field_70177_z;
                this.field_70127_C = this.field_70125_A;
            }
            if (this.age > this.returnAge) {
                this.returning = true;
            }
            if (this.returning) {
                this.field_70145_X = true;
                Vector3d ownerPos = playerEntity.func_213303_ch().func_72441_c(0.0, 1.0, 0.0);
                Vector3d motion = ownerPos.func_178788_d(this.func_213303_ch());
                this.func_213317_d(motion.func_72432_b().func_186678_a(0.75));
            }
            float distance = this.func_70032_d((Entity)playerEntity);
            if (this.age > 8 && distance < 3.0f && this.func_70089_S()) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)this.scythe, (int)this.slot);
                if (!playerEntity.field_71075_bZ.field_75098_d) {
                    int cooldown = 100 - 80 * (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)MalumEnchantments.REBOUND.get()), (ItemStack)this.scythe) - 1);
                    playerEntity.func_184811_cZ().func_185145_a(this.scythe.func_77973_b(), cooldown);
                }
                this.func_70106_y();
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("scythe", (INBT)this.scythe.serializeNBT());
        if (this.ownerUUID != null) {
            compound.func_186854_a("ownerUUID", this.ownerUUID);
        }
        compound.func_74768_a("slot", this.slot);
        compound.func_74776_a("damage", this.damage);
        compound.func_74768_a("age", this.age);
        compound.func_74757_a("returning", this.returning);
        compound.func_74768_a("returnAge", this.returnAge);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("scythe")) {
            this.scythe = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("scythe"));
        }
        this.field_70180_af.func_187227_b(SCYTHE, (Object)this.scythe);
        if (compound.func_74764_b("ownerUUID")) {
            this.ownerUUID = compound.func_186857_a("ownerUUID");
            this.owner = this.owner();
        }
        this.slot = compound.func_74762_e("slot");
        this.damage = compound.func_74760_g("damage");
        this.age = compound.func_74762_e("age");
        this.returning = compound.func_74767_n("returning");
        this.returnAge = compound.func_74762_e("returnAge");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public float func_70111_Y() {
        return 4.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCYTHE, (Object)ItemStack.field_190927_a);
    }

    protected Item func_213885_i() {
        if (this.scythe == null) {
            this.scythe = (ItemStack)this.field_70180_af.func_187225_a(SCYTHE);
        }
        return this.scythe.func_77973_b();
    }

    public ItemStack func_184543_l() {
        if (this.scythe == null) {
            this.scythe = (ItemStack)this.field_70180_af.func_187225_a(SCYTHE);
        }
        return this.scythe;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_180427_aV() {
        return true;
    }
}

