/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.spiritpipe;

import com.google.common.collect.Maps;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.spiritpipe.IPipeAcceptor;
import com.sammy.malum.common.blocks.spiritpipe.SpiritPipeTileEntity;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SpiritPipeBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final Direction[] FACING_VALUES = Direction.values();
    public static final VoxelShape core = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape down = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    public static final VoxelShape up = Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape north = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    public static final VoxelShape south = Block.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape west = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    public static final VoxelShape east = Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final Map<Direction, BooleanProperty> FACING_TO_CONNECTION_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    });
    protected final VoxelShape[] shapes;

    public SpiritPipeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SpiritPipeTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.func_175625_s(fromPos) instanceof SpiritPipeTileEntity) {
            SpiritPipeTileEntity tileEntity = (SpiritPipeTileEntity)worldIn.func_175625_s(fromPos);
            if (!tileEntity.needsUpdate) {
                tileEntity.needsUpdate = true;
                MalumHelper.updateAndNotifyState(worldIn, pos);
            }
        }
        worldIn.func_175656_a(pos, this.figureOutState(worldIn, pos));
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH});
        builder.func_206894_a(new Property[]{SOUTH});
        builder.func_206894_a(new Property[]{WEST});
        builder.func_206894_a(new Property[]{EAST});
        builder.func_206894_a(new Property[]{DOWN});
        builder.func_206894_a(new Property[]{UP});
    }

    protected VoxelShape[] makeShapes() {
        VoxelShape[] shapes = new VoxelShape[64];
        VoxelShape[] dunswe = new VoxelShape[]{down, up, north, south, west, east};
        for (int i = 0; i < 64; ++i) {
            shapes[i] = core;
            for (int j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                shapes[i] = VoxelShapes.func_197872_a((VoxelShape)shapes[i], (VoxelShape)dunswe[j]);
            }
        }
        return shapes;
    }

    public int getShapeIndex(BlockState state) {
        int index = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.func_177229_b((Property)FACING_TO_CONNECTION_MAP.get(FACING_VALUES[j]))).booleanValue()) continue;
            index |= 1 << j;
        }
        return index;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.figureOutState(context.func_195991_k(), context.func_195995_a());
    }

    public BlockState figureOutState(World world, BlockPos pos) {
        Predicate<TileEntity> tileEntityPredicate = t -> t instanceof IPipeAcceptor || t instanceof SpiritPipeTileEntity;
        BlockState finalState = this.func_176223_P();
        TileEntity north = world.func_175625_s(pos.func_177978_c());
        TileEntity south = world.func_175625_s(pos.func_177968_d());
        TileEntity west = world.func_175625_s(pos.func_177976_e());
        TileEntity east = world.func_175625_s(pos.func_177974_f());
        TileEntity down = world.func_175625_s(pos.func_177977_b());
        TileEntity up = world.func_175625_s(pos.func_177984_a());
        if (tileEntityPredicate.test(north)) {
            finalState = (BlockState)finalState.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(true));
        }
        if (tileEntityPredicate.test(south)) {
            finalState = (BlockState)finalState.func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(true));
        }
        if (tileEntityPredicate.test(west)) {
            finalState = (BlockState)finalState.func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(true));
        }
        if (tileEntityPredicate.test(east)) {
            finalState = (BlockState)finalState.func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(true));
        }
        if (tileEntityPredicate.test(down)) {
            finalState = (BlockState)finalState.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(true));
        }
        if (tileEntityPredicate.test(up)) {
            finalState = (BlockState)finalState.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(true));
        }
        return finalState;
    }
}

