/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.runetable;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.runetable.bounding.RuneTableBoundingBlockTileEntity;
import com.sammy.malum.common.items.SpiritItem;
import com.sammy.malum.common.rites.ActivatorRite;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.blocks.MalumTileEntities;
import com.sammy.malum.core.modcontent.MalumRuneTableRecipes;
import com.sammy.malum.core.systems.inventory.SimpleInventory;
import com.sammy.malum.core.systems.multiblock.MultiblockTileEntity;
import com.sammy.malum.core.systems.recipes.ItemIngredient;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.core.systems.spirits.SpiritHelper;
import com.sammy.malum.core.systems.tileentities.SimpleTileEntity;
import com.sammy.malum.network.NetworkManager;
import com.sammy.malum.network.packets.particle.BurstParticlePacket;
import com.sammy.malum.network.packets.particle.SmallBurstParticlePacket;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;

public class RuneTableTileEntity
extends MultiblockTileEntity
implements ITickableTileEntity,
ActivatorRite.IAssembled {
    public SimpleInventory inventory = new SimpleInventory(1, 64){

        protected void onContentsChanged(int slot) {
            RuneTableTileEntity.this.func_70296_d();
            RuneTableTileEntity.this.func_145836_u();
            MalumHelper.updateAndNotifyState(RuneTableTileEntity.this.field_145850_b, RuneTableTileEntity.this.field_174879_c);
        }
    };

    public RuneTableTileEntity() {
        super((TileEntityType)MalumTileEntities.RUNE_TABLE_TILE_ENTITY.get());
    }

    public void func_73660_a() {
        if (MalumHelper.areWeOnServer(this.field_145850_b)) {
            return;
        }
        if (this.inventory.getStackInSlot(0).func_77973_b() instanceof SpiritItem) {
            SpiritItem item = (SpiritItem)this.inventory.getStackInSlot(0).func_77973_b();
            Color color = item.type.color;
            Vector3d pos = RuneTableTileEntity.itemPos(this);
            double x = pos.field_72450_a;
            double y = pos.field_72448_b + Math.sin((float)(this.field_145850_b.func_82737_E() % 360L) / 20.0f) * (double)0.05f;
            double z = pos.field_72449_c;
            SpiritHelper.spiritParticles(this.field_145850_b, x, y, z, color);
        }
    }

    @Override
    public void readData(CompoundNBT compound) {
        this.inventory.readData(compound);
        super.readData(compound);
    }

    @Override
    public CompoundNBT writeData(CompoundNBT compound) {
        this.inventory.writeData(compound);
        return super.writeData(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public static Vector3d itemPos(SimpleTileEntity tileEntity) {
        return MalumHelper.pos(tileEntity.func_174877_v()).func_178787_e(RuneTableTileEntity.itemOffset());
    }

    public static Vector3d itemOffset() {
        return new Vector3d(0.5, 1.25, 0.5);
    }

    @Override
    public void assemble(BlockPos pos, ArrayList<MalumSpiritType> spirits) {
        MalumRuneTableRecipes.MalumRuneTableRecipe recipe;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (BlockPos part : this.parts) {
            if (!(this.field_145850_b.func_175625_s(part) instanceof RuneTableBoundingBlockTileEntity)) continue;
            RuneTableBoundingBlockTileEntity tileEntity = (RuneTableBoundingBlockTileEntity)this.field_145850_b.func_175625_s(part);
            ItemStack stack = tileEntity.inventory.getStackInSlot(0);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        ItemStack centerStack = this.inventory.getStackInSlot(0);
        if (!centerStack.func_190926_b()) {
            stacks.add(1, centerStack);
        }
        if ((recipe = MalumRuneTableRecipes.getRecipe(stacks)) != null) {
            ItemStack stack;
            int outputCount = 0;
            do {
                for (int i = 0; i < stacks.size(); ++i) {
                    stack = stacks.get(i);
                    ItemIngredient ingredient = recipe.itemIngredients.get(i);
                    stack.func_190918_g(ingredient.count);
                }
                outputCount += recipe.outputIngredient.count;
            } while (recipe.matches(stacks));
            do {
                int stackCount = Math.min(outputCount, 64);
                outputCount -= stackCount;
                stack = recipe.outputIngredient.getItem();
                stack.func_190920_e(stackCount);
                ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.25f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), stack);
                this.field_145850_b.func_217376_c((Entity)itemEntity);
            } while (outputCount != 0);
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), MalumSounds.RUNE_TABLE_CRAFT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        for (BlockPos part : this.parts) {
            MalumHelper.updateAndNotifyState(this.field_145850_b, part);
            NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(pos)), (Object)SmallBurstParticlePacket.fromSpirits((double)((float)part.func_177958_n() + 0.5f), (double)((float)part.func_177956_o() + 1.15f), (double)((float)part.func_177952_p() + 0.5f), spirits));
        }
        MalumHelper.updateAndNotifyState(this.field_145850_b, this.func_174877_v());
        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(pos)), (Object)BurstParticlePacket.fromSpirits((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.25f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), spirits));
    }
}

