/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.blocks.runetable;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.runetable.RuneTableTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RuneTableBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)-1.0, (double)10.0, (double)-1.0, (double)17.0, (double)16.0, (double)17.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public RuneTableBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (MalumHelper.areWeOnClient(worldIn)) {
            return ActionResultType.SUCCESS;
        }
        if (handIn.equals((Object)Hand.MAIN_HAND) && worldIn.func_175625_s(pos) instanceof RuneTableTileEntity) {
            ((RuneTableTileEntity)worldIn.func_175625_s((BlockPos)pos)).inventory.playerHandleItem(worldIn, player, handIn);
            MalumHelper.updateState(worldIn, pos);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (worldIn instanceof ServerWorld) {
            this.func_220062_a(state, (ServerWorld)worldIn, pos, player.func_184607_cu());
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_220062_a(BlockState state, ServerWorld worldIn, BlockPos pos, ItemStack stack) {
        if (worldIn.func_175625_s(pos) instanceof RuneTableTileEntity) {
            RuneTableTileEntity tileEntity = (RuneTableTileEntity)worldIn.func_175625_s(pos);
            for (ItemStack itemStack : tileEntity.inventory.stacks()) {
                worldIn.func_217376_c((Entity)new ItemEntity((World)worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), itemStack));
            }
        }
        super.func_220062_a(state, worldIn, pos, stack);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RuneTableTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
        super.func_206840_a(builder);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }
}

