/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.sammy.malum.core.systems.particles.ParticleRendering;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderUtil {
    public static final RenderState.TransparencyState ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState NORMAL_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static RenderType GLOWING_SPRITE = RenderType.func_228632_a_((String)"malum:glowing_sprite", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(false)).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228719_a_(new RenderState.LightmapState(false)).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228728_a_(false));
    public static RenderType GLOWING = RenderType.func_228632_a_((String)"malum:glowing", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(true)).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228719_a_(new RenderState.LightmapState(false)).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228728_a_(false));
    public static RenderType DELAYED_PARTICLE = RenderType.func_228632_a_((String)"malum:delayed_particle", (VertexFormat)DefaultVertexFormats.field_181704_d, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(true)).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228719_a_(new RenderState.LightmapState(false)).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228726_a_(NORMAL_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_215262_g, false, false)).func_228728_a_(false));
    public static RenderType GLOWING_PARTICLE = RenderType.func_228632_a_((String)"malum:glowing_particle", (VertexFormat)DefaultVertexFormats.field_181704_d, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(true)).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228719_a_(new RenderState.LightmapState(false)).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_215262_g, false, false)).func_228728_a_(false));
    public static RenderType GLOWING_BLOCK_PARTICLE = RenderType.func_228632_a_((String)"malum:glowing_particle", (VertexFormat)DefaultVertexFormats.field_181704_d, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(true)).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228719_a_(new RenderState.LightmapState(false)).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, false)).func_228728_a_(false));
    static double ticks = 0.0;
    private static final float ROOT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static void litQuad(MatrixStack mStack, IRenderTypeBuffer buffer, double x, double y, double w, double h, float r, float g, float b, TextureAtlasSprite sprite) {
        IVertexBuilder builder = buffer.getBuffer(GLOWING_SPRITE);
        float f7 = sprite.func_94209_e();
        float f8 = sprite.func_94212_f();
        float f5 = sprite.func_94206_g();
        float f6 = sprite.func_94210_h();
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, (float)x, (float)y + (float)h, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f7, f6).func_181675_d();
        builder.func_227888_a_(mat, (float)x + (float)w, (float)y + (float)h, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f8, f6).func_181675_d();
        builder.func_227888_a_(mat, (float)x + (float)w, (float)y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f8, f5).func_181675_d();
        builder.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f7, f5).func_181675_d();
    }

    public static void litQuad(MatrixStack mStack, IRenderTypeBuffer buffer, double x, double y, double w, double h, float r, float g, float b, float u, float v, float uw, float vh) {
        IVertexBuilder builder = buffer.getBuffer(GLOWING_SPRITE);
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, (float)x, (float)y + (float)h, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u, v + vh).func_181675_d();
        builder.func_227888_a_(mat, (float)x + (float)w, (float)y + (float)h, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u + uw, v + vh).func_181675_d();
        builder.func_227888_a_(mat, (float)x + (float)w, (float)y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u + uw, v).func_181675_d();
        builder.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u, v).func_181675_d();
    }

    public static void litBillboard(MatrixStack mStack, IRenderTypeBuffer buffer, double x, double y, double z, float r, float g, float b, TextureAtlasSprite sprite) {
        IVertexBuilder builder = buffer.getBuffer(GLOWING_SPRITE);
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d vector3d = renderInfo.func_216785_c();
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        float f = (float)x;
        float f1 = (float)y;
        float f2 = (float)z;
        Quaternion quaternion = renderInfo.func_227995_f_();
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)};
        float f4 = 1.0f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = sprite.func_94209_e();
        float f8 = sprite.func_94212_f();
        float f5 = sprite.func_94206_g();
        float f6 = sprite.func_94210_h();
        Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(mat, avector3f[0].func_195899_a(), avector3f[0].func_195900_b(), avector3f[0].func_195902_c()).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f8, f6).func_181675_d();
        builder.func_227888_a_(mat, avector3f[1].func_195899_a(), avector3f[1].func_195900_b(), avector3f[1].func_195902_c()).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f8, f5).func_181675_d();
        builder.func_227888_a_(mat, avector3f[2].func_195899_a(), avector3f[2].func_195900_b(), avector3f[2].func_195902_c()).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f7, f5).func_181675_d();
        builder.func_227888_a_(mat, avector3f[3].func_195899_a(), avector3f[3].func_195900_b(), avector3f[3].func_195902_c()).func_227885_a_(r, g, b, 1.0f).func_225583_a_(f7, f6).func_181675_d();
    }

    public static void dragon(MatrixStack mStack, IRenderTypeBuffer buf, double x, double y, double z, float radius, float r, float g, float b) {
        float f5 = 0.5f;
        float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
        Random random = new Random(432L);
        IVertexBuilder builder = buf.getBuffer(GLOWING);
        mStack.func_227860_a_();
        mStack.func_227861_a_(x, y, z);
        float rotation = ParticleRendering.getClientTicks() / 200.0f;
        int i = 0;
        while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
            mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
            mStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
            mStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
            mStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + rotation * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
            Matrix4f mat = mStack.func_227866_c_().func_227870_a_();
            float alpha = 1.0f - f7;
            builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, -ROOT_3 * (f4 *= 0.05f * radius), f3 *= 0.05f * radius, -0.5f * f4).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, ROOT_3 * f4, f3, -0.5f * f4).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, ROOT_3 * f4, f3, -0.5f * f4).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, f3, 1.0f * f4).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, 0.0f, 0.0f).func_227885_a_(r, g, b, alpha).func_181675_d();
            builder.func_227888_a_(mat, 0.0f, f3, 1.0f * f4).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            builder.func_227888_a_(mat, -ROOT_3 * f4, f3, -0.5f * f4).func_227885_a_(r, g, b, 0.0f).func_181675_d();
            ++i;
        }
        mStack.func_227865_b_();
    }
}

