/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum;

import com.sammy.malum.core.data.MalumBlockStateProvider;
import com.sammy.malum.core.data.MalumBlockTagProvider;
import com.sammy.malum.core.data.MalumItemModelProvider;
import com.sammy.malum.core.data.MalumItemTagProvider;
import com.sammy.malum.core.data.MalumLangProvider;
import com.sammy.malum.core.data.MalumLootTableProvider;
import com.sammy.malum.core.data.MalumRecipeProvider;
import com.sammy.malum.core.init.MalumEffects;
import com.sammy.malum.core.init.MalumEntities;
import com.sammy.malum.core.init.MalumSounds;
import com.sammy.malum.core.init.blocks.MalumBlocks;
import com.sammy.malum.core.init.blocks.MalumTileEntities;
import com.sammy.malum.core.init.enchantments.MalumEnchantments;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.init.particles.MalumParticles;
import com.sammy.malum.core.init.worldgen.MalumFeatures;
import com.sammy.malum.core.systems.particles.ParticleRendering;
import java.util.Random;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="malum")
public class MalumMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "malum";
    public static final Random RANDOM = new Random();

    public MalumMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        MalumEnchantments.ENCHANTMENTS.register(modBus);
        MalumBlocks.BLOCKS.register(modBus);
        MalumItems.ITEMS.register(modBus);
        MalumTileEntities.TILE_ENTITIES.register(modBus);
        MalumEntities.ENTITY_TYPES.register(modBus);
        MalumEffects.EFFECTS.register(modBus);
        MalumParticles.PARTICLES.register(modBus);
        MalumSounds.SOUNDS.register(modBus);
        MalumFeatures.FEATURES.register(modBus);
        modBus.addListener(this::gatherData);
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinecraftForge.EVENT_BUS.register((Object)new ParticleRendering());
            return new Object();
        });
    }

    public void gatherData(GatherDataEvent event) {
        MalumBlockTagProvider provider = new MalumBlockTagProvider(event.getGenerator(), event.getExistingFileHelper());
        event.getGenerator().func_200390_a((IDataProvider)new MalumBlockStateProvider(event.getGenerator(), event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new MalumItemModelProvider(event.getGenerator(), event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new MalumLangProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)provider);
        event.getGenerator().func_200390_a((IDataProvider)new MalumLootTableProvider(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new MalumItemTagProvider(event.getGenerator(), provider, event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new MalumRecipeProvider(event.getGenerator()));
    }
}

