/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum;

import com.sammy.malum.common.items.equipment.curios.MalumCurioItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class MalumHelper {
    public static Color darker(Color color, int times) {
        for (int i = 0; i < times; ++i) {
            color = color.darker();
        }
        return color;
    }

    public static Color brighter(Color color, int times) {
        for (int i = 0; i < times; ++i) {
            color = color.brighter();
        }
        return color;
    }

    public static <T extends LivingEntity> boolean damageItem(ItemStack stack, int amount, T entityIn, Consumer<T> onBroken) {
        if (!(entityIn.field_70170_p.field_72995_K || entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d || !stack.func_77984_f() || !stack.func_96631_a(amount = stack.func_77973_b().damageItem(stack, amount, entityIn, onBroken), entityIn.func_70681_au(), entityIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)entityIn : null))) {
            onBroken.accept(entityIn);
            Item item = stack.func_77973_b();
            stack.func_190918_g(1);
            if (entityIn instanceof PlayerEntity) {
                ((PlayerEntity)entityIn).func_71029_a(Stats.field_199088_e.func_199076_b((Object)item));
            }
            stack.func_196085_b(0);
            return true;
        }
        return false;
    }

    public static <T extends Entity> Entity getClosestEntity(List<T> entities, Vector3d pos) {
        double cachedDistance = -1.0;
        Entity resultEntity = null;
        for (Entity entity : entities) {
            double newDistance = entity.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (cachedDistance != -1.0 && !(newDistance < cachedDistance)) continue;
            cachedDistance = newDistance;
            resultEntity = entity;
        }
        return resultEntity;
    }

    public static Vector3d pos(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static Vector3f fPos(BlockPos pos) {
        return new Vector3f((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
    }

    public static Vector3d randPos(BlockPos pos, Random rand, double min, double max) {
        double x = MathHelper.func_82716_a((Random)rand, (double)min, (double)max) + (double)pos.func_177958_n();
        double y = MathHelper.func_82716_a((Random)rand, (double)min, (double)max) + (double)pos.func_177956_o();
        double z = MathHelper.func_82716_a((Random)rand, (double)min, (double)max) + (double)pos.func_177952_p();
        return new Vector3d(x, y, z);
    }

    public static boolean areWeOnClient(World world) {
        return world.field_72995_K;
    }

    public static boolean areWeOnServer(World world) {
        return !MalumHelper.areWeOnClient(world);
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation("malum", path);
    }

    public static <T> ArrayList<T> toArrayList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> ArrayList<T> toArrayList(Stream<T> items) {
        return items.collect(Collectors.toCollection(ArrayList::new));
    }

    public static ArrayList<ItemStack> nonEmptyStackList(ArrayList<ItemStack> stacks) {
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            nonEmptyStacks.add(stack);
        }
        return nonEmptyStacks;
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    public static <T> boolean hasDuplicate(T[] things) {
        HashSet thingSet = new HashSet();
        return !Arrays.stream(things).allMatch(thingSet::add);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static void setBlockStateWithExistingProperties(World world, BlockPos pos, BlockState newState, int flags) {
        BlockState oldState = world.func_180495_p(pos);
        BlockState finalState = newState;
        for (Property property : oldState.func_235904_r_()) {
            if (!newState.func_235901_b_(property)) continue;
            finalState = MalumHelper.newStateWithOldProperty(oldState, finalState, property);
        }
        world.func_184138_a(pos, oldState, finalState, flags);
        world.func_180501_a(pos, finalState, flags);
    }

    public static <T extends Comparable<T>> BlockState newStateWithOldProperty(BlockState oldState, BlockState newState, Property<T> property) {
        return (BlockState)newState.func_206870_a(property, oldState.func_177229_b(property));
    }

    public static CompoundNBT writeBlockPos(CompoundNBT compoundNBT, BlockPos pos) {
        compoundNBT.func_74768_a("X", pos.func_177958_n());
        compoundNBT.func_74768_a("Y", pos.func_177956_o());
        compoundNBT.func_74768_a("Z", pos.func_177952_p());
        return compoundNBT;
    }

    public static CompoundNBT writeBlockPosExtra(CompoundNBT compoundNBT, BlockPos pos, String extra) {
        compoundNBT.func_74768_a(extra + "X", pos.func_177958_n());
        compoundNBT.func_74768_a(extra + "Y", pos.func_177956_o());
        compoundNBT.func_74768_a(extra + "Z", pos.func_177952_p());
        return compoundNBT;
    }

    public static BlockPos readBlockPos(CompoundNBT tag) {
        return new BlockPos(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"));
    }

    public static BlockPos readBlockPosExtra(CompoundNBT tag, String extra) {
        return new BlockPos(tag.func_74762_e(extra + "X"), tag.func_74762_e(extra + "Y"), tag.func_74762_e(extra + "Z"));
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int x, int y, int z, Predicate<BlockPos> predicate) {
        ArrayList<BlockPos> blocks = MalumHelper.getBlocks(pos, x, y, z);
        blocks.removeIf(b -> !predicate.test((BlockPos)b));
        return blocks;
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int x, int y, int z) {
        return MalumHelper.getBlocks(pos, -x, -y, -z, x, y, z);
    }

    public static ArrayList<BlockPos> getBlocks(BlockPos pos, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    positions.add(pos.func_177982_a(x, y, z));
                }
            }
        }
        return positions;
    }

    public static void updateState(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_184138_a(pos, state, state, 2);
    }

    public static void updateAndNotifyState(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_184138_a(pos, state, state, 2);
        state.func_235734_a_((IWorld)worldIn, pos, 2);
    }

    public static void updateState(World worldIn, BlockPos pos) {
        MalumHelper.updateState(worldIn.func_180495_p(pos), worldIn, pos);
    }

    public static void updateAndNotifyState(World worldIn, BlockPos pos) {
        MalumHelper.updateAndNotifyState(worldIn.func_180495_p(pos), worldIn, pos);
    }

    public static Vector3d circlePosition(Vector3d pos, float distance, float current, float total) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distance * Math.cos(angle);
        double dz2 = (double)distance * Math.sin(angle);
        Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
        double x = vector2f.field_72450_a * (double)distance;
        double z = vector2f.field_72449_c * (double)distance;
        return pos.func_72441_c(x, 0.0, z);
    }

    public static Vector3d rotatedCirclePosition(Vector3d pos, float distance, float current, float total, long gameTime, float time) {
        return MalumHelper.rotatedCirclePosition(pos, distance, distance, current, total, gameTime, time);
    }

    public static Vector3d rotatedCirclePosition(Vector3d pos, float distanceX, float distanceZ, float current, float total, long gameTime, float time) {
        double angle = (double)(current / total) * (Math.PI * 2);
        double dx2 = (double)distanceX * Math.cos(angle += (double)((float)gameTime % time / time) * (Math.PI * 2));
        double dz2 = (double)distanceZ * Math.sin(angle);
        Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
        double x = vector2f.field_72450_a * (double)distanceX;
        double z = vector2f.field_72449_c * (double)distanceZ;
        return pos.func_72441_c(x, 0.0, z);
    }

    public static ArrayList<Vector3d> blockOutlinePositions(World world, BlockPos pos) {
        ArrayList<Vector3d> arrayList = new ArrayList<Vector3d>();
        double d0 = 0.5625;
        Random random = world.field_73012_v;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.func_177972_a(direction);
            if (world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) continue;
            Direction.Axis direction$axis = direction.func_176740_k();
            double d1 = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.func_82601_c() : (double)random.nextFloat();
            double d2 = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.func_96559_d() : (double)random.nextFloat();
            double d3 = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.func_82599_e() : (double)random.nextFloat();
            arrayList.add(new Vector3d((double)pos.func_177958_n() + d1, (double)pos.func_177956_o() + d2, (double)pos.func_177952_p() + d3));
        }
        return arrayList;
    }

    public static void giveAmplifyingEffect(Effect effect, LivingEntity target, int duration, int amplifier, int cap) {
        EffectInstance instance = target.func_70660_b(effect);
        if (instance != null) {
            amplifier += instance.field_76461_c + 1;
        }
        target.func_195064_c(new EffectInstance(effect, duration, Math.min(amplifier, cap)));
    }

    public static void giveStackingEffect(Effect effect, LivingEntity target, int duration, int amplifier) {
        EffectInstance instance = target.func_70660_b(effect);
        if (instance != null) {
            duration += instance.field_76460_b;
        }
        target.func_195064_c(new EffectInstance(effect, duration, amplifier));
    }

    public static void giveItemToPlayerNoSound(PlayerEntity player, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        World world = player.field_70170_p;
        ItemStack remainder = stack;
        if (!remainder.func_190926_b()) {
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)remainder, (boolean)false);
        }
        if (!remainder.func_190926_b() && !world.field_72995_K) {
            ItemEntity entityitem = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), remainder);
            entityitem.func_174867_a(40);
            entityitem.func_213317_d(entityitem.func_213322_ci().func_216372_d(0.0, 1.0, 0.0));
            world.func_217376_c((Entity)entityitem);
        }
    }

    @Nonnull
    public static Optional<ImmutableTriple<String, Integer, ItemStack>> findCosmeticCurio(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(handler -> {
            Map curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHelper = stacksHandler.getCosmeticStacks();
                for (i = 0; i < stackHandler.getSlots(); ++i) {
                    stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
                for (i = 0; i < cosmeticStackHelper.getSlots(); ++i) {
                    stack = cosmeticStackHelper.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public static ItemStack heldItem(LivingEntity livingEntity, Predicate<ItemStack> stackPredicate) {
        if (livingEntity.field_184622_au != null && stackPredicate.test(livingEntity.func_184586_b(livingEntity.field_184622_au))) {
            return livingEntity.func_184586_b(livingEntity.field_184622_au);
        }
        if (stackPredicate.test(livingEntity.func_184586_b(livingEntity.func_184600_cs()))) {
            return livingEntity.func_184586_b(livingEntity.func_184600_cs());
        }
        if (stackPredicate.test(livingEntity.func_184586_b(Hand.MAIN_HAND))) {
            return livingEntity.func_184586_b(Hand.MAIN_HAND);
        }
        if (stackPredicate.test(livingEntity.func_184586_b(Hand.OFF_HAND))) {
            return livingEntity.func_184586_b(Hand.OFF_HAND);
        }
        return null;
    }

    public static boolean hasCurioEquipped(LivingEntity entity, RegistryObject<Item> curio) {
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)curio.get(), entity).isPresent();
    }

    public static ArrayList<MalumCurioItem> equippedMalumCurios(LivingEntity entity) {
        IItemHandlerModifiable handler = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve().get();
        ArrayList<MalumCurioItem> items = new ArrayList<MalumCurioItem>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            Item item = handler.getStackInSlot(i).func_77973_b();
            if (!(item instanceof MalumCurioItem)) continue;
            items.add((MalumCurioItem)item);
        }
        return items;
    }

    public static ArrayList<ItemStack> equippedCurios(LivingEntity entity) {
        IItemHandlerModifiable handler = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve().get();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.add(handler.getStackInSlot(i));
        }
        return stacks;
    }

    public static ArrayList<ItemStack> equippedCurios(LivingEntity entity, Predicate<ItemStack> predicate) {
        IItemHandlerModifiable handler = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios(entity).resolve().get();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!predicate.test(stack)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static void applyEnchantments(LivingEntity user, Entity target, ItemStack stack) {
        EnchantmentHelper.IEnchantmentVisitor visitor = (enchantment, level) -> enchantment.func_151368_a(user, target, level);
        if (user != null) {
            EnchantmentHelper.func_77516_a((EnchantmentHelper.IEnchantmentVisitor)visitor, (Iterable)user.func_184209_aF());
        }
        if (user instanceof PlayerEntity) {
            EnchantmentHelper.func_77518_a((EnchantmentHelper.IEnchantmentVisitor)visitor, (ItemStack)stack);
        }
    }

    public static void giveItemToEntity(ItemStack item, LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)entity), (ItemStack)item);
        } else {
            ItemEntity entityitem = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_(), item);
            entityitem.func_174867_a(40);
            entityitem.func_213317_d(entityitem.func_213322_ci().func_216372_d(0.0, 1.0, 0.0));
            entity.field_70170_p.func_217376_c((Entity)entityitem);
        }
    }
}

