/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.projects.oneplayersleeping.config;

import be.nevoka.projects.oneplayersleeping.OnePlayerSleeping;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class OPSConfig {

    public static class Common {
        public static ForgeConfigSpec.BooleanValue onePlayerSleeping;
        private static final ForgeConfigSpec.Builder COMMON;
        public static final ForgeConfigSpec common_config;

        public static void init(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            onePlayerSleeping = builder.comment("One player needs to sleep to pass the night. [default: true]").define("onePlayerSleeping", true);
            builder.pop();
        }

        public static void loadConfig(ForgeConfigSpec config, Path path) {
            OnePlayerSleeping.LOGGER.debug("Loading server config");
            CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
            OnePlayerSleeping.LOGGER.debug("Built server config");
            file.load();
            OnePlayerSleeping.LOGGER.debug("Loaded server config");
            config.setConfig((CommentedConfig)file);
        }

        static {
            COMMON = new ForgeConfigSpec.Builder();
            Common.init(COMMON);
            common_config = COMMON.build();
            OnePlayerSleeping.LOGGER.debug("Config for server has been initialized");
        }
    }
}

