/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.feders_scarecrows.common.entities;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class TemplateScarecrowEntity
extends LivingEntity {
    private static final EntitySize MARKER_DIMENSIONS = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize BABY_DIMENSIONS = EntityType.field_200789_c.func_220334_j().func_220313_a(0.5f);
    public static final DataParameter<Byte> DATA_CLIENT_FLAGS = EntityDataManager.func_187226_a(TemplateScarecrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_200617_0_ -> p_200617_0_ instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)p_200617_0_).canBeRidden();
    private final NonNullList<ItemStack> handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private boolean invisible;
    public long lastHit;

    public TemplateScarecrowEntity(EntityType<? extends TemplateScarecrowEntity> p_31553_, World p_31554_) {
        super(p_31553_, p_31554_);
        this.field_70138_W = 0.0f;
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.func_189652_ae();
    }

    public boolean func_70613_aW() {
        return super.func_70613_aW() && this.hasPhysics();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_CLIENT_FLAGS, (Object)0);
    }

    public Iterable<ItemStack> func_184214_aD() {
        return this.handItems;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return this.armorItems;
    }

    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        switch (p_184582_1_.func_188453_a()) {
            case HAND: {
                return (ItemStack)this.handItems.get(p_184582_1_.func_188454_b());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(p_184582_1_.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
        switch (p_184201_1_.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(p_184201_2_);
                this.handItems.set(p_184201_1_.func_188454_b(), (Object)p_184201_2_);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(p_184201_2_);
                this.armorItems.set(p_184201_1_.func_188454_b(), (Object)p_184201_2_);
            }
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("Invisible", this.func_82150_aj());
        p_213281_1_.func_74757_a("Small", this.isSmall());
        if (this.isMarker()) {
            p_213281_1_.func_74757_a("Marker", this.isMarker());
        }
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_82142_c(p_70037_1_.func_74767_n("Invisible"));
        this.setSmall(p_70037_1_.func_74767_n("Small"));
        this.setMarker(p_70037_1_.func_74767_n("Marker"));
        this.field_70145_X = !this.hasPhysics();
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity p_82167_1_) {
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), RIDABLE_MINECARTS);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f((Entity)this);
        }
    }

    public ActionResultType func_184199_a(PlayerEntity p_184199_1_, Vector3d p_184199_2_, Hand p_184199_3_) {
        return ActionResultType.PASS;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (DamageSource.field_76380_i.equals(p_70097_1_)) {
                this.func_70106_y();
                return false;
            }
            if (!(this.func_180431_b(p_70097_1_) || this.invisible || this.isMarker())) {
                if (p_70097_1_.func_94541_c()) {
                    this.brokenByAnything(p_70097_1_);
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(p_70097_1_)) {
                    if (this.func_70027_ad()) {
                        this.causeDamage(p_70097_1_, 0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(p_70097_1_) && this.func_110143_aJ() > 0.5f) {
                    this.causeDamage(p_70097_1_, 4.0f);
                    return false;
                }
                boolean flag = p_70097_1_.func_76364_f() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)p_70097_1_.func_76364_f()).func_213874_s() > 0;
                boolean flag2 = "player".equals(p_70097_1_.func_76355_l());
                if (!flag2 && !flag) {
                    return false;
                }
                if (p_70097_1_.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)p_70097_1_.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (p_70097_1_.func_180136_u()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.func_70106_y();
                    return flag1;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.lastHit > 5L && !flag) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(p_70097_1_);
                    this.showBreakingParticles();
                    this.func_70106_y();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.lastHit = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource p_213817_1_, float p_213817_2_) {
        float f = this.func_110143_aJ();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.brokenByAnything(p_213817_1_);
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void brokenByPlayer(DamageSource p_213815_1_) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)new ItemStack((IItemProvider)Items.field_179565_cj));
        this.brokenByAnything(p_213815_1_);
    }

    private void brokenByAnything(DamageSource p_31654_) {
        this.playBrokenSound();
        this.func_213345_d(p_31654_);
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * (this.func_70631_g_() ? 0.5f : 0.9f);
    }

    public double func_70033_W() {
        return this.isMarker() ? 0.0 : (double)0.1f;
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.hasPhysics()) {
            super.func_213352_e(p_213352_1_);
        }
    }

    public void func_181013_g(float p_181013_1_) {
        this.field_70760_ar = this.field_70126_B = p_181013_1_;
        this.field_70758_at = this.field_70759_as = p_181013_1_;
    }

    public void func_70034_d(float p_70034_1_) {
        this.field_70760_ar = this.field_70126_B = p_70034_1_;
        this.field_70758_at = this.field_70759_as = p_70034_1_;
    }

    protected void func_175135_B() {
        this.func_82142_c(this.invisible);
    }

    public void func_82142_c(boolean p_82142_1_) {
        this.invisible = p_82142_1_;
        super.func_82142_c(p_82142_1_);
    }

    public boolean func_70631_g_() {
        return this.isSmall();
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_180427_aV() {
        return this.func_82150_aj();
    }

    public PushReaction func_184192_z() {
        return this.isMarker() ? PushReaction.IGNORE : super.func_184192_z();
    }

    private void setSmall(boolean p_175420_1_) {
        this.field_70180_af.func_187227_b(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.field_70180_af.func_187225_a(DATA_CLIENT_FLAGS), 1, p_175420_1_));
    }

    public boolean isSmall() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    private void setMarker(boolean p_181027_1_) {
        this.field_70180_af.func_187227_b(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.field_70180_af.func_187225_a(DATA_CLIENT_FLAGS), 16, p_181027_1_));
    }

    public boolean isMarker() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && !this.isMarker();
    }

    public boolean func_85031_j(Entity p_85031_1_) {
        return p_85031_1_ instanceof PlayerEntity && !this.field_70170_p.func_175660_a((PlayerEntity)p_85031_1_, this.func_233580_cy_());
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    protected SoundEvent func_184588_d(int p_184588_1_) {
        return SoundEvents.field_187704_k;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187707_l;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (DATA_CLIENT_FLAGS.equals(p_184206_1_)) {
            this.func_213323_x_();
            this.field_70156_m = !this.isMarker();
        }
        super.func_184206_a(p_184206_1_);
    }

    public boolean func_190631_cK() {
        return false;
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntitySize getDimensionsMarker(boolean p_242330_1_) {
        if (p_242330_1_) {
            return MARKER_DIMENSIONS;
        }
        return this.func_70631_g_() ? BABY_DIMENSIONS : this.func_200600_R().func_220334_j();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241842_k(float p_241842_1_) {
        if (this.isMarker()) {
            AxisAlignedBB axisalignedbb = this.getDimensionsMarker(false).func_242286_a(this.func_213303_ch());
            BlockPos blockpos = this.func_233580_cy_();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)new BlockPos(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c), (BlockPos)new BlockPos(axisalignedbb.field_72336_d, axisalignedbb.field_72337_e, axisalignedbb.field_72334_f))) {
                int j = Math.max(this.field_70170_p.func_226658_a_(LightType.BLOCK, blockpos1), this.field_70170_p.func_226658_a_(LightType.SKY, blockpos1));
                if (j == 15) {
                    return Vector3d.func_237489_a_((Vector3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.func_185334_h();
            }
            return Vector3d.func_237489_a_((Vector3i)blockpos);
        }
        return super.func_241842_k(p_241842_1_);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return null;
    }
}

