/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.feders_scarecrows.common.entities;

import com.itayfeder.feders_scarecrows.common.entities.ScarecrowType;
import com.itayfeder.feders_scarecrows.common.entities.TemplateScarecrowEntity;
import com.itayfeder.feders_scarecrows.common.items.CostumeItem;
import com.itayfeder.feders_scarecrows.init.EntityTypeInit;
import com.itayfeder.feders_scarecrows.init.ItemInit;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;

public class ScarecrowEntity
extends TemplateScarecrowEntity {
    private static final DataParameter<String> DATA_TYPE = EntityDataManager.func_187226_a(ScarecrowEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    public ScarecrowEntity(EntityType<ScarecrowEntity> scarecrowEntityType, World level) {
        super(EntityTypeInit.SCARECROW, level);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        AxisAlignedBB range = new AxisAlignedBB(this.func_226277_ct_() - 24.0, this.func_226278_cu_() - 4.0, this.func_226281_cx_() - 24.0, this.func_226277_ct_() + 24.0, this.func_226278_cu_() + 4.0, this.func_226281_cx_() + 24.0);
        Predicate<Entity> ENTITY_PREDICATE = EntityPredicates.field_180132_d.and(entity -> {
            if (entity instanceof CreatureEntity) {
                return this.getScarecrowType().tag.func_230235_a_((Object)((CreatureEntity)entity).func_200600_R());
            }
            return false;
        });
        List entities = this.field_70170_p.func_175647_a(CreatureEntity.class, range, ENTITY_PREDICATE);
        for (CreatureEntity entity2 : entities) {
            if (entity2 == null) continue;
            double xt = entity2.field_70142_S;
            double yt = entity2.field_70137_T;
            double zt = entity2.field_70136_U;
            int x1 = MathHelper.func_76128_c((double)this.field_70142_S);
            int y1 = MathHelper.func_76128_c((double)this.field_70137_T);
            int z1 = MathHelper.func_76128_c((double)this.field_70136_U);
            double x2 = xt - (double)x1;
            double y2 = yt - (double)y1;
            double z2 = zt - (double)z1;
            if (MathHelper.func_76130_a((int)((int)x2)) >= 24 || MathHelper.func_76130_a((int)((int)z2)) >= 8 || MathHelper.func_76130_a((int)((int)y2)) >= 24) continue;
            entity2.func_70624_b((LivingEntity)null);
            Vector3d vec3d = RandomPositionGenerator.func_223548_b((CreatureEntity)entity2, (int)20, (int)7, (Vector3d)new Vector3d(entity2.field_70142_S, entity2.field_70137_T, entity2.field_70136_U));
            WorldBorder wb = this.field_70170_p.func_175723_af();
            if (vec3d == null || !wb.func_177746_a(new BlockPos(entity2.field_70142_S, entity2.field_70137_T, entity2.field_70136_U)) || !(this.func_70092_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) >= this.func_70068_e((Entity)entity2))) continue;
            entity2.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 2.0);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TYPE, (Object)ScarecrowType.DEFAULT.type);
    }

    public void setScarecrowType(ScarecrowType p_28929_) {
        this.field_70180_af.func_187227_b(DATA_TYPE, (Object)p_28929_.type);
    }

    public ScarecrowType getScarecrowType() {
        return ScarecrowType.byType((String)this.field_70180_af.func_187225_a(DATA_TYPE));
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ItemInit.SCARECROW);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74778_a("Type", this.getScarecrowType().type);
    }

    @Override
    public void func_70037_a(CompoundNBT p_28936_) {
        super.func_70037_a(p_28936_);
        this.setScarecrowType(ScarecrowType.byType(p_28936_.func_74779_i("Type")));
    }

    private ItemStack getCostumeStack() {
        switch (this.getScarecrowType()) {
            default: {
                return ItemStack.field_190927_a;
            }
            case WOLF: {
                return new ItemStack((IItemProvider)ItemInit.WOLF_COSTUME);
            }
            case OCELOT: {
                return new ItemStack((IItemProvider)ItemInit.OCELOT_COSTUME);
            }
            case GUARDIAN: 
        }
        return new ItemStack((IItemProvider)ItemInit.GUARDIAN_COSTUME);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        this.func_199701_a_(this.getCostumeStack());
    }

    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        ItemStack itemstack = p_184230_1_.func_184586_b(p_184230_2_);
        if (itemstack.func_77973_b() instanceof CostumeItem) {
            if (!p_184230_1_.field_71075_bZ.field_75098_d) {
                this.func_213337_cE();
            }
            this.setScarecrowType(((CostumeItem)itemstack.func_77973_b()).getType());
            this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187728_s, this.func_184176_by(), 1.0f, 1.0f, false);
            if (!p_184230_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_190926_b()) {
            if (!p_184230_1_.field_71075_bZ.field_75098_d) {
                this.func_213337_cE();
            }
            this.setScarecrowType(ScarecrowType.DEFAULT);
            this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187728_s, this.func_184176_by(), 1.0f, 1.0f, false);
            if (!p_184230_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_184230_a(p_184230_1_, p_184230_2_);
    }
}

