/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.commands;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.util.RegistryHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class BiomeDictCommand {
    public static final SuggestionProvider<CommandSource> BIOME_DICTIONARY_ENTRIES = SuggestionProviders.func_197494_a((ResourceLocation)StructureGelMod.locate("biome_dictionary_entries"), (context, builder) -> ISuggestionProvider.func_197014_a((Iterable)BiomeDictionary.REGISTRY.getKeys(), (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSource> get() {
        LiteralArgumentBuilder command = Commands.func_197057_a((String)"biomedict");
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"gettypes").executes(BiomeDictCommand::getTypes)).then(Commands.func_197056_a((String)"biome", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SuggestionProviders.field_239574_d_).executes(context -> BiomeDictCommand.getTypes((CommandContext<CommandSource>)context, (ResourceLocation)context.getArgument("biome", ResourceLocation.class)))));
        command.then(Commands.func_197057_a((String)"getbiomes").then(Commands.func_197056_a((String)"dictionaryentry", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(BIOME_DICTIONARY_ENTRIES).executes(context -> BiomeDictCommand.getBiomes((CommandContext<CommandSource>)context, (ResourceLocation)context.getArgument("dictionaryentry", ResourceLocation.class)))));
        return command;
    }

    private static int getTypes(CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        Optional<RegistryKey<Biome>> biome = RegistryHelper.getKey((IWorld)world, Registry.field_239720_u_, world.func_226691_t_(new BlockPos(((CommandSource)context.getSource()).func_197036_d())));
        if (biome.isPresent()) {
            return BiomeDictCommand.getTypes(context, biome.get().func_240901_a_());
        }
        return 0;
    }

    private static int getTypes(CommandContext<CommandSource> context, ResourceLocation key) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("[" + key.toString() + "]").func_240699_a_(TextFormatting.GREEN), true);
        List<String> types = BiomeDictionary.getAllTypes((RegistryKey<Biome>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)key)).stream().map(b -> b.getRegistryName().toString()).sorted().collect(Collectors.toList());
        if (types.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(key.toString() + " has no registered types."), true);
        } else {
            types.forEach(t -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - " + t), true));
        }
        return 1;
    }

    private static int getBiomes(CommandContext<CommandSource> context, ResourceLocation key) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("[" + key.toString() + "]").func_240699_a_(TextFormatting.GREEN), true);
        List<String> biomes = BiomeDictionary.get(key).getAllBiomes().stream().map(rk -> rk.func_240901_a_().toString()).sorted().collect(Collectors.toList());
        if (biomes.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(key.toString() + " has no registered biomes."), true);
        } else {
            biomes.forEach(b -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(" - " + b), true));
        }
        return 1;
    }
}

