/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.biome_dictionary;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.registrars.BiomeRegistrar;
import com.legacy.structure_gel.util.Internal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeType
implements IForgeRegistryEntry<BiomeType> {
    private ResourceLocation registryName = BiomeDictionary.EMPTY_NAME;
    private Set<ResourceLocation> biomes = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> parents = new HashSet<ResourceLocation>();

    public BiomeType(ResourceLocation name, Set<ResourceLocation> parents, Set<ResourceLocation> biomes) {
        if (name != null) {
            this.registryName = name;
        }
        if (parents != null) {
            this.parents = new HashSet<ResourceLocation>(parents);
        }
        if (biomes != null) {
            this.biomes = new HashSet<ResourceLocation>(biomes);
        }
    }

    @Internal
    private BiomeType() {
    }

    public static BiomeType create(ResourceLocation name) {
        BiomeType biomeType = new BiomeType();
        biomeType.registryName = name;
        return biomeType;
    }

    @Internal
    protected static BiomeType create(String name) {
        return BiomeType.create(StructureGelMod.locate(name));
    }

    public BiomeType biomes(RegistryKey<Biome> ... biomes) {
        this.addBiomes(Arrays.asList(biomes).stream().map(r -> r.func_240901_a_()).collect(Collectors.toSet()));
        return this;
    }

    public BiomeType biomes(Biome ... biomes) {
        this.addBiomes(Arrays.asList(biomes).stream().map(r -> r.getRegistryName()).collect(Collectors.toSet()));
        return this;
    }

    public BiomeType biomes(ResourceLocation ... biomes) {
        this.addBiomes(Arrays.asList(biomes).stream().collect(Collectors.toSet()));
        return this;
    }

    public BiomeType biomes(BiomeRegistrar ... biomes) {
        this.addBiomes(Arrays.asList(biomes).stream().map(b -> b.getName()).collect(Collectors.toSet()));
        return this;
    }

    public BiomeType biomes(String modid, String ... biomes) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (String biome : biomes) {
            set.add(new ResourceLocation(modid, biome));
        }
        this.addBiomes(set);
        return this;
    }

    public BiomeType addBiomes(Set<ResourceLocation> biomes) {
        this.getBiomes().addAll(biomes);
        return this;
    }

    public BiomeType addBiome(RegistryKey<Biome> biome) {
        return this.addBiome(biome.func_240901_a_());
    }

    public BiomeType addBiome(Biome biome) {
        return this.addBiome(biome.getRegistryName());
    }

    public BiomeType addBiome(ResourceLocation biome) {
        this.getBiomes().add(biome);
        return this;
    }

    public BiomeType addBiome(BiomeRegistrar biome) {
        return this.addBiome(biome.getName());
    }

    public Set<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public BiomeType setBiomes(Set<ResourceLocation> biomes) {
        this.biomes = biomes.stream().collect(Collectors.toSet());
        return this;
    }

    public BiomeType parents(ResourceLocation ... parents) {
        this.setParents(new HashSet<ResourceLocation>(Arrays.asList(parents)));
        return this;
    }

    public BiomeType parents(BiomeType ... parents) {
        this.parents = Arrays.asList(parents).stream().map(b -> b.getRegistryName()).collect(Collectors.toSet());
        return this;
    }

    public BiomeType addParents(Set<ResourceLocation> parents) {
        this.getParents().addAll(parents);
        return this;
    }

    public BiomeType addParent(ResourceLocation parent) {
        this.getParents().add(parent);
        return this;
    }

    public Set<ResourceLocation> getParents() {
        return this.parents;
    }

    public BiomeType setParents(Set<ResourceLocation> parents) {
        this.parents = new HashSet<ResourceLocation>(parents);
        return this;
    }

    public Set<RegistryKey<Biome>> getAllBiomes() {
        Set<RegistryKey<Biome>> biomes = this.getBiomes().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).containsKey(arg_0)).map(r -> RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)r)).collect(Collectors.toSet());
        for (ResourceLocation parent : this.getParents()) {
            if (!BiomeDictionary.REGISTRY.containsKey(parent)) continue;
            biomes.addAll(((BiomeType)BiomeDictionary.REGISTRY.getValue(parent)).getAllBiomes());
        }
        return biomes;
    }

    public boolean contains(RegistryKey<Biome> key) {
        return this.contains(key.func_240901_a_());
    }

    public boolean contains(Biome biome) {
        return this.contains(biome.getRegistryName());
    }

    public boolean contains(ResourceLocation key) {
        return this.getAllBiomes().stream().anyMatch(registryKey -> registryKey.func_240901_a_().equals((Object)key));
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeType) {
            return ((BiomeType)obj).getRegistryName().equals((Object)this.getRegistryName());
        }
        return false;
    }

    public String toString() {
        String parents = String.join((CharSequence)", ", this.getParents().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toSet()));
        String biomes = String.join((CharSequence)", ", this.getBiomes().stream().map(ResourceLocation::toString).sorted().collect(Collectors.toSet()));
        return String.format("name = %s, parents = [%s], biomes = [%s]", this.getRegistryName().toString(), parents, biomes);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public BiomeType setRegistryName(ResourceLocation name) {
        this.registryName = name;
        return this;
    }

    public Class<BiomeType> getRegistryType() {
        return BiomeType.class;
    }
}

