/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.access_helpers;

import com.legacy.structure_gel.StructureGelMod;
import com.legacy.structure_gel.util.GelCollectors;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.FeatureJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.ListJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.Structure;

public class JigsawAccessHelper {
    public static void addIllagerStructures(Structure<?> ... structures) {
        Structure.field_236384_t_ = GelCollectors.addToList(Structure.field_236384_t_, Arrays.asList(structures));
    }

    public static void clearPool(ResourceLocation pool) {
        if (JigsawAccessHelper.getJigsawPattern(pool).isPresent()) {
            JigsawAccessHelper.getJigsawPattern((ResourceLocation)pool).get().field_214953_e.clear();
        } else {
            StructureGelMod.LOGGER.warn(String.format("Could not clear the pool %s as it does not exist.", pool));
        }
    }

    public static void addToPool(ResourceLocation pool, List<Pair<JigsawPiece, Integer>> pieces) {
        if (!JigsawAccessHelper.getJigsawPattern(pool).isPresent()) {
            StructureGelMod.LOGGER.warn(String.format("Could not add to %s because it has not been created yet.", pool));
            return;
        }
        JigsawAccessHelper.getJigsawPattern(pool).ifPresent(jigsawPattern -> {
            for (Pair pair : pieces) {
                for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                    jigsawPattern.field_214953_e.add(pair.getFirst());
                }
            }
        });
    }

    public static void removeFromPool(ResourceLocation pool, ResourceLocation pieceName) {
        if (JigsawAccessHelper.getJigsawPattern(pool).isPresent()) {
            JigsawAccessHelper.getJigsawPattern((ResourceLocation)pool).get().field_214953_e.removeIf(piece -> {
                if (piece instanceof SingleJigsawPiece) {
                    return JigsawAccessHelper.getSingleJigsawPieceLocation((SingleJigsawPiece)piece).equals((Object)pieceName);
                }
                if (piece instanceof ListJigsawPiece) {
                    return JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, pieceName);
                }
                return false;
            });
        } else {
            StructureGelMod.LOGGER.warn(String.format("Could not remove from %s because it has not been created yet.", pool));
        }
    }

    public static void removeFromPool(ResourceLocation pool, Feature<?> feature) {
        if (JigsawAccessHelper.getJigsawPattern(pool).isPresent()) {
            JigsawAccessHelper.getJigsawPattern((ResourceLocation)pool).get().field_214953_e.removeIf(piece -> {
                if (piece instanceof FeatureJigsawPiece) {
                    return ((ConfiguredFeature)((FeatureJigsawPiece)piece).field_214870_a.get()).field_222737_a == feature;
                }
                if (piece instanceof ListJigsawPiece) {
                    return JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, feature);
                }
                return false;
            });
        } else {
            StructureGelMod.LOGGER.warn(String.format("Could not remove from %s because it has not been created yet.", pool));
        }
    }

    public static boolean removeFromListJigsaw(ListJigsawPiece listJigsawPiece, ResourceLocation pieceName) {
        listJigsawPiece.field_214867_a.removeIf(piece -> {
            if (piece instanceof SingleJigsawPiece) {
                return JigsawAccessHelper.getSingleJigsawPieceLocation((SingleJigsawPiece)piece).equals((Object)pieceName);
            }
            if (piece instanceof ListJigsawPiece) {
                JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, pieceName);
                return ((ListJigsawPiece)piece).field_214867_a.isEmpty();
            }
            return false;
        });
        return listJigsawPiece.field_214867_a.isEmpty();
    }

    public static boolean removeFromListJigsaw(ListJigsawPiece listJigsawPiece, Feature<?> feature) {
        listJigsawPiece.field_214867_a.removeIf(piece -> {
            if (piece instanceof FeatureJigsawPiece) {
                return ((ConfiguredFeature)((FeatureJigsawPiece)piece).field_214870_a.get()).field_222737_a == feature;
            }
            if (piece instanceof ListJigsawPiece) {
                JigsawAccessHelper.removeFromListJigsaw((ListJigsawPiece)piece, feature);
                return ((ListJigsawPiece)piece).field_214867_a.isEmpty();
            }
            return false;
        });
        return listJigsawPiece.field_214867_a.isEmpty();
    }

    public static ResourceLocation getSingleJigsawPieceLocation(SingleJigsawPiece piece) {
        return (ResourceLocation)piece.field_236839_c_.left().get();
    }

    public static List<JigsawPiece> getListJigsawPiecePieces(ListJigsawPiece piece) {
        return piece.field_214867_a;
    }

    public static ConfiguredFeature<?, ?> getFeatureJigsawPieceFeatures(FeatureJigsawPiece piece) {
        return (ConfiguredFeature)piece.field_214870_a.get();
    }

    public static Optional<JigsawPattern> getJigsawPattern(ResourceLocation location) {
        return WorldGenRegistries.field_243656_h.func_241873_b(location);
    }
}

