/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure.piece;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModStructurePieces;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.StructureHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class NBTPiece
extends StructurePiece {
    private ResourceLocation structureID;
    private Rotation rotation;
    private Mirror mirror;
    private Template structure;
    private BlockPos pos;
    private int erosion;
    private boolean cover;

    public NBTPiece(ResourceLocation structureID, Template structure, BlockPos pos, int erosion, boolean cover, Random random) {
        super(ModStructurePieces.NBT_PIECE, 0);
        this.structureID = structureID;
        this.structure = structure;
        this.rotation = Rotation.func_222466_a((Random)random);
        this.mirror = Mirror.values()[random.nextInt(3)];
        this.pos = StructureHelper.offsetPos(pos, structure, this.rotation, this.mirror);
        this.erosion = erosion;
        this.cover = cover;
        this.makeBoundingBox();
    }

    public NBTPiece(TemplateManager p_i50677_1_, CompoundNBT nbt) {
        super(ModStructurePieces.NBT_PIECE, nbt);
        this.structureID = new ResourceLocation(nbt.func_74779_i("Template"));
        this.rotation = Rotation.values()[nbt.func_74762_e("rotation")];
        this.mirror = Mirror.values()[nbt.func_74762_e("mirror")];
        this.erosion = nbt.func_74762_e("erosion");
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pos"));
        this.cover = nbt.func_74767_n("cover");
        this.structure = StructureHelper.readStructure(this.structureID);
        this.makeBoundingBox();
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74778_a("Template", this.structureID.toString());
        tagCompound.func_74768_a("rotation", this.rotation.ordinal());
        tagCompound.func_74768_a("mirror", this.mirror.ordinal());
        tagCompound.func_74768_a("erosion", this.erosion);
        tagCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pos));
        tagCompound.func_74757_a("cover", this.cover);
    }

    private void makeBoundingBox() {
        this.field_74887_e = StructureHelper.getStructureBounds(this.pos, this.structure, this.rotation, this.mirror);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        MutableBoundingBox bounds = new MutableBoundingBox(box);
        bounds.field_78894_e = this.field_74887_e.field_78894_e;
        bounds.field_78895_b = this.field_74887_e.field_78895_b;
        PlacementSettings placementData = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(this.mirror).func_186223_a(bounds);
        this.structure.func_237152_b_((IServerWorld)world, this.pos, placementData, random);
        if (this.erosion > 0) {
            bounds.field_78893_d = ModMathHelper.min(bounds.field_78893_d, this.field_74887_e.field_78893_d);
            bounds.field_78897_a = ModMathHelper.max(bounds.field_78897_a, this.field_74887_e.field_78897_a);
            bounds.field_78892_f = ModMathHelper.min(bounds.field_78892_f, this.field_74887_e.field_78892_f);
            bounds.field_78896_c = ModMathHelper.max(bounds.field_78896_c, this.field_74887_e.field_78896_c);
            StructureHelper.erode(world, bounds, this.erosion, random);
        }
        if (this.cover) {
            StructureHelper.cover(world, bounds, random);
        }
        return true;
    }
}

