/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.StalactiteBlock;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class StalactiteFeature
extends Feature<NoFeatureConfig> {
    private final boolean ceiling;
    private final Block[] ground;
    private final Block block;

    public StalactiteFeature(boolean ceiling, Block block, Block ... ground) {
        super(NoFeatureConfig.field_236558_a_);
        this.ceiling = ceiling;
        this.ground = ground;
        this.block = block;
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!this.isGround(world.func_180495_p(this.ceiling ? pos.func_177984_a() : pos.func_177977_b()).func_177230_c())) {
            return false;
        }
        BlockPos.Mutable mut = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        int height = rand.nextInt(16);
        int dir = this.ceiling ? -1 : 1;
        boolean stalagnate = false;
        for (int i = 1; i <= height; ++i) {
            mut.func_185336_p(pos.func_177956_o() + i * dir);
            BlockState state = world.func_180495_p((BlockPos)mut);
            if (state.func_185904_a().func_76222_j()) continue;
            stalagnate = state.func_235714_a_(ModTags.GEN_TERRAIN);
            height = i;
            break;
        }
        if (!stalagnate && height > 7) {
            height = rand.nextInt(8);
        }
        float center = (float)height * 0.5f;
        for (int i = 0; i < height; ++i) {
            mut.func_185336_p(pos.func_177956_o() + i * dir);
            int size = stalagnate ? MathHelper.func_76125_a((int)((int)(MathHelper.func_76135_e((float)((float)i - center)) + 1.0f)), (int)1, (int)7) : height - i - 1;
            boolean waterlogged = !world.func_204610_c((BlockPos)mut).func_206888_e();
            BlockState base = (BlockState)((BlockState)this.block.func_176223_P().func_206870_a((Property)StalactiteBlock.SIZE, (Comparable)Integer.valueOf(size))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(waterlogged));
            BlockState state = stalagnate ? (BlockState)base.func_206870_a((Property)StalactiteBlock.IS_FLOOR, (Comparable)Boolean.valueOf(dir > 0 ? (float)i < center : (float)i > center)) : (BlockState)base.func_206870_a((Property)StalactiteBlock.IS_FLOOR, (Comparable)Boolean.valueOf(dir > 0));
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, state);
        }
        return true;
    }

    private boolean isGround(Block block) {
        for (Block b : this.ground) {
            if (b != block) continue;
            return true;
        }
        return false;
    }
}

