/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.PosInfo;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LacugroveFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.func_235714_a_(ModTags.END_GROUND)) {
            return true;
        }
        if (ModBlocks.LACUGROVE.isTreeLog((BlockState)state)) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.LACUGROVE_LEAVES.get()) {
            return true;
        }
        if (state.func_185904_a().equals(Material.field_151585_k)) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    };
    private static final Function<BlockState, Boolean> IGNORE = state -> ModBlocks.LACUGROVE.isTreeLog((BlockState)state);
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (ModBlocks.LACUGROVE.isTreeLog(info.getStateUp()) && ModBlocks.LACUGROVE.isTreeLog(info.getStateDown())) {
            return ((Block)ModBlocks.LACUGROVE.log.get()).func_176223_P();
        }
        return info.getState();
    };

    public LacugroveFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, NoFeatureConfig config) {
        if (!world.func_180495_p(blockPos.func_177977_b()).func_235714_a_(ModTags.END_GROUND)) {
            return false;
        }
        float size = ModMathHelper.randRange(15, 25, random);
        List<Vector3f> spline = SplineHelper.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, size, 0.0f, 6);
        SplineHelper.offsetParts(spline, random, 1.0f, 0.0f, 1.0f);
        if (!SplineHelper.canGenerate(spline, blockPos, (IWorldReader)world, REPLACE)) {
            return false;
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        float radius = ModMathHelper.randRange(6.0f, 8.0f, random);
        Vector3f center = spline.get(4);
        this.leavesBall((IWorld)world, blockPos.func_177963_a((double)center.func_195899_a(), (double)center.func_195900_b(), (double)center.func_195902_c()), radius *= (size - 15.0f) / 20.0f + 1.0f, random, noise);
        radius = ModMathHelper.randRange(1.2f, 1.8f, random);
        SDF function = SplineHelper.buildSDF(spline, radius, 0.7f, bpos -> ((Block)ModBlocks.LACUGROVE.bark.get()).func_176223_P());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursive((IWorld)world, blockPos);
        spline = spline.subList(4, 6);
        SplineHelper.fillSpline(spline, (IWorld)world, ((Block)ModBlocks.LACUGROVE.bark.get()).func_176223_P(), blockPos, REPLACE);
        BlockPos.Mutable mut = new BlockPos.Mutable();
        int offset = random.nextInt(2);
        block0: for (int i = 0; i < 100; ++i) {
            int top;
            double distance;
            double px = blockPos.func_177958_n() + ModMathHelper.randRange(-5, 5, random);
            double pz = blockPos.func_177952_p() + ModMathHelper.randRange(-5, 5, random);
            mut.func_223471_o(ModMathHelper.floor(px + 0.5));
            mut.func_223472_q(ModMathHelper.floor(pz + 0.5));
            if ((mut.func_177958_n() + mut.func_177952_p() + offset & 1) != 0 || !((distance = 3.5 - ModMathHelper.length(px - (double)blockPos.func_177958_n(), pz - (double)blockPos.func_177952_p()) * 0.5) > 0.0)) continue;
            int minY = ModMathHelper.floor((double)blockPos.func_177956_o() - distance * 0.5);
            int maxY = ModMathHelper.floor((double)blockPos.func_177956_o() + distance + random.nextDouble());
            boolean generate = false;
            for (int y = minY; y < maxY; ++y) {
                mut.func_185336_p(y);
                if (!world.func_180495_p((BlockPos)mut).func_235714_a_(ModTags.END_GROUND)) continue;
                generate = true;
                break;
            }
            if (!generate) continue;
            for (int y = top = maxY - 1; y >= minY; --y) {
                mut.func_185336_p(y);
                BlockState state = world.func_180495_p((BlockPos)mut);
                if (!state.func_185904_a().func_76222_j() && !state.func_185904_a().equals(Material.field_151585_k) && !state.func_235714_a_(ModTags.END_GROUND)) continue block0;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, y == top ? (Block)ModBlocks.LACUGROVE.bark.get() : (Block)ModBlocks.LACUGROVE.log.get());
            }
        }
        return true;
    }

    private void leavesBall(IWorld world, BlockPos pos, float radius, Random random, OpenSimplexNoise noise) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)((Block)ModBlocks.LACUGROVE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(6)));
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 3.0f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(new SDFTranslate().setTranslate(0.0f, -radius - 2.0f, 0.0f).setSource(sphere));
        BlockPos.Mutable mut = new BlockPos.Mutable();
        sphere.addPostProcess(info -> {
            if (random.nextInt(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.func_196958_f()) continue;
                    return info.getState();
                }
                info.setState(((Block)ModBlocks.LACUGROVE.bark.get()).func_176223_P());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.func_223471_o(x + info.getPos().func_177958_n());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.func_223472_q(z + info.getPos().func_177952_p());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.func_185336_p(y + info.getPos().func_177956_o());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.func_177230_c() instanceof LeavesBlock) || d >= (distance = ((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore(world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                BlockPos p = pos.func_177963_a(random.nextGaussian() * 1.0, random.nextGaussian() * 1.0, random.nextGaussian() * 1.0);
                boolean place = true;
                for (Direction d : Direction.values()) {
                    BlockState state = world.func_180495_p(p.func_177972_a(d));
                    if (ModBlocks.LACUGROVE.isTreeLog(state) || state.func_203425_a((Block)ModBlocks.LACUGROVE_LEAVES.get())) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, p, (Block)ModBlocks.LACUGROVE.bark.get());
            }
        }
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, (Block)ModBlocks.LACUGROVE.bark.get());
    }
}

