/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.PosInfo;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DragonTreeFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.func_235714_a_(ModTags.END_GROUND)) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.DRAGON_TREE_LEAVES.get()) {
            return true;
        }
        if (state.func_185904_a().equals(Material.field_151585_k)) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    };
    private static final Function<BlockState, Boolean> IGNORE = state -> ModBlocks.DRAGON_TREE.isTreeLog((BlockState)state);
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (ModBlocks.DRAGON_TREE.isTreeLog(info.getStateUp()) && ModBlocks.DRAGON_TREE.isTreeLog(info.getStateDown())) {
            return ((Block)ModBlocks.DRAGON_TREE.log.get()).func_176223_P();
        }
        return info.getState();
    };
    private static final List<Vector3f> BRANCH = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.3f, 0.0f), new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE1 = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE2 = SplineHelper.copySpline(SIDE1);
    private static final List<Vector3f> ROOT;

    public DragonTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        float size = ModMathHelper.randRange(10, 25, rand);
        List<Vector3f> spline = SplineHelper.makeSpline(0.0f, 0.0f, 0.0f, 0.0f, size, 0.0f, 6);
        SplineHelper.offsetParts(spline, rand, 1.0f, 0.0f, 1.0f);
        if (!SplineHelper.canGenerate(spline, pos, (IWorldReader)world, REPLACE)) {
            return false;
        }
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150350_a);
        Vector3f last = SplineHelper.getPos(spline, 3.5f);
        OpenSimplexNoise noise = new OpenSimplexNoise(rand.nextLong());
        float radius = size * ModMathHelper.randRange(0.5f, 0.7f, rand);
        this.makeCap(world, pos.func_177963_a((double)last.func_195899_a(), (double)last.func_195900_b(), (double)last.func_195902_c()), radius, rand, noise);
        last = spline.get(0);
        this.makeRoots(world, pos.func_177963_a((double)last.func_195899_a(), (double)last.func_195900_b(), (double)last.func_195902_c()), radius, rand);
        radius = ModMathHelper.randRange(1.2f, 2.3f, rand);
        SDF function = SplineHelper.buildSDF(spline, radius, 1.2f, bpos -> ((Block)ModBlocks.DRAGON_TREE.bark.get()).func_176223_P());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        return true;
    }

    private void makeCap(ISeedReader world, BlockPos pos, float radius, Random random, OpenSimplexNoise noise) {
        int count = (int)radius;
        int offset = (int)(BRANCH.get(BRANCH.size() - 1).func_195900_b() * radius);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * ModMathHelper.randRange(0.85f, 1.15f, random);
            List<Vector3f> branch = SplineHelper.copySpline(BRANCH);
            SplineHelper.rotateSpline(branch, angle);
            SplineHelper.scale(branch, scale);
            SplineHelper.fillSpline(branch, (IWorld)world, ((Block)ModBlocks.DRAGON_TREE.bark.get()).func_176223_P(), pos, REPLACE);
            branch = SplineHelper.copySpline(SIDE1);
            SplineHelper.rotateSpline(branch, angle);
            SplineHelper.scale(branch, scale);
            SplineHelper.fillSpline(branch, (IWorld)world, ((Block)ModBlocks.DRAGON_TREE.bark.get()).func_176223_P(), pos, REPLACE);
            branch = SplineHelper.copySpline(SIDE2);
            SplineHelper.rotateSpline(branch, angle);
            SplineHelper.scale(branch, scale);
            SplineHelper.fillSpline(branch, (IWorld)world, ((Block)ModBlocks.DRAGON_TREE.bark.get()).func_176223_P(), pos, REPLACE);
        }
        this.leavesBall(world, pos.func_177981_b(offset), radius * 1.15f + 2.0f, random, noise);
    }

    private void makeRoots(ISeedReader world, BlockPos pos, float radius, Random random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * ModMathHelper.randRange(0.85f, 1.15f, random);
            List<Vector3f> branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline(branch, angle);
            SplineHelper.scale(branch, scale);
            Vector3f last = branch.get(branch.size() - 1);
            if (!world.func_180495_p(pos.func_177963_a((double)last.func_195899_a(), (double)last.func_195900_b(), (double)last.func_195902_c())).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
            SplineHelper.fillSpline(branch, (IWorld)world, ((Block)ModBlocks.DRAGON_TREE.bark.get()).func_176223_P(), pos, REPLACE);
        }
    }

    private void leavesBall(ISeedReader world, BlockPos pos, float radius, Random random, OpenSimplexNoise noise) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)((Block)ModBlocks.DRAGON_TREE_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource(sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource(sub);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 1.5f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.nextFloat() * 3.0f - 1.5f)).setSource(sphere);
        BlockPos.Mutable mut = new BlockPos.Mutable();
        sphere.addPostProcess(info -> {
            if (random.nextInt(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.func_196958_f()) continue;
                    return info.getState();
                }
                info.setState(((Block)ModBlocks.DRAGON_TREE.bark.get()).func_176223_P());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.func_223471_o(x + info.getPos().func_177958_n());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.func_223472_q(z + info.getPos().func_177952_p());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.func_185336_p(y + info.getPos().func_177956_o());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.func_177230_c() instanceof LeavesBlock) || d >= (distance = ((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                BlockPos p = pos.func_177963_a(random.nextGaussian() * 1.0, random.nextGaussian() * 1.0, random.nextGaussian() * 1.0);
                boolean place = true;
                for (Direction d : Direction.values()) {
                    BlockState state = world.func_180495_p(p.func_177972_a(d));
                    if (ModBlocks.DRAGON_TREE.isTreeLog(state) || state.func_203425_a((Block)ModBlocks.DRAGON_TREE_LEAVES.get())) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, p, (Block)ModBlocks.DRAGON_TREE.bark.get());
            }
        }
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, (Block)ModBlocks.DRAGON_TREE.bark.get());
    }

    static {
        Vector3f offset1 = new Vector3f(-0.4f, -0.6f, 0.0f);
        Vector3f offset2 = new Vector3f(0.4f, 0.6f, 0.0f);
        SplineHelper.offset(SIDE1, offset1);
        SplineHelper.offset(SIDE2, offset1);
        SplineHelper.rotateSpline(SIDE1, 0.5f);
        SplineHelper.rotateSpline(SIDE2, -0.5f);
        SplineHelper.offset(SIDE1, offset2);
        SplineHelper.offset(SIDE2, offset2);
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

