/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.integration.jei.alloying;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.recipes.AlloyingRecipe;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class AlloyingRecipeCategory
implements IRecipeCategory<AlloyingRecipe> {
    protected static final int FIRST_INPUT_SLOT = 0;
    protected static final int SECOND_INPUT_SLOT = 1;
    protected static final int FUEL_SLOT = 2;
    protected static final int OUTPUT_SLOT = 3;
    private final IDrawable background;
    private final IDrawable icon;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("betterendforge", "textures/gui/jei/jei_smelter_gui.png");
    public static final ResourceLocation UID = new ResourceLocation("betterendforge", "alloying");

    public AlloyingRecipeCategory(final IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.END_STONE_SMELTER.get()));
        this.background = guiHelper.createDrawable(GUI_TEXTURE, 0, 0, 106, 54);
        this.staticFlame = guiHelper.createDrawable(GUI_TEXTURE, 106, 0, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(GUI_TEXTURE, 106, 14, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends AlloyingRecipe> getRecipeClass() {
        return AlloyingRecipe.class;
    }

    public String getTitle() {
        return new TranslationTextComponent("gui.jei.category.alloying").getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AlloyingRecipe recipe, IIngredients ingredients) {
        NonNullList inputs = NonNullList.func_191196_a();
        inputs.addAll(recipe.func_192400_c());
        inputs.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150402_ci, Items.field_151072_bj, Items.field_151129_at}));
        ingredients.setInputIngredients((List)inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlloyingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 22, 0);
        guiItemStacks.init(2, true, 11, 36);
        guiItemStacks.init(3, false, 84, 18);
        guiItemStacks.set(ingredients);
    }

    protected IDrawableAnimated getArrow(AlloyingRecipe recipe) {
        int smeltTime = recipe.getSmeltTime();
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)smeltTime);
    }

    protected void drawSmeltTime(AlloyingRecipe recipe, MatrixStack matrixStack, int y) {
        int smeltTime = recipe.getSmeltTime();
        if (smeltTime > 0) {
            int smeltTimeSeconds = smeltTime / 20;
            TranslationTextComponent timeString = new TranslationTextComponent("gui.jei.category.alloying.time.seconds", new Object[]{smeltTimeSeconds});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)timeString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)timeString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    protected void drawExperience(AlloyingRecipe recipe, MatrixStack matrixStack, int y) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            TranslationTextComponent experienceString = new TranslationTextComponent("gui.jei.category.alloying.experience", new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_238414_a_((ITextProperties)experienceString);
            fontRenderer.func_243248_b(matrixStack, (ITextComponent)experienceString, (float)(this.background.getWidth() - stringWidth), (float)y, -8355712);
        }
    }

    public void draw(AlloyingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(matrixStack, 12, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(matrixStack, 47, 18);
        this.drawExperience(recipe, matrixStack, 0);
        this.drawSmeltTime(recipe, matrixStack, 45);
    }
}

