/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block.template;

import java.util.function.ToIntFunction;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.init.ModTileEntityTypes;
import mod.beethoven92.betterendforge.common.tileentity.PedestalTileEntity;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;

public class PedestalBlock
extends Block {
    public static final EnumProperty<BlockProperties.PedestalState> STATE = BlockProperties.PEDESTAL_STATE;
    public static final BooleanProperty HAS_ITEM = BlockProperties.HAS_ITEM;
    public static final BooleanProperty HAS_LIGHT = BlockProperties.HAS_LIGHT;
    private static final VoxelShape SHAPE_DEFAULT;
    private static final VoxelShape SHAPE_COLUMN;
    private static final VoxelShape SHAPE_PILLAR;
    private static final VoxelShape SHAPE_PEDESTAL_TOP;
    private static final VoxelShape SHAPE_COLUMN_TOP;
    private static final VoxelShape SHAPE_BOTTOM;
    protected float height = 1.0f;

    public PedestalBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.DEFAULT))).func_206870_a((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public static ToIntFunction<BlockState> light() {
        return state -> (Boolean)state.func_177229_b((Property)HAS_LIGHT) != false ? 12 : 0;
    }

    public float getHeight(BlockState state) {
        if (state.func_177230_c() instanceof PedestalBlock && state.func_177229_b(STATE) == BlockProperties.PedestalState.PEDESTAL_TOP) {
            return this.height - 0.2f;
        }
        return this.height;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_203425_a((Block)this)) {
            switch ((BlockProperties.PedestalState)((Object)state.func_177229_b(STATE))) {
                case BOTTOM: {
                    return SHAPE_BOTTOM;
                }
                case PEDESTAL_TOP: {
                    return SHAPE_PEDESTAL_TOP;
                }
                case COLUMN_TOP: {
                    return SHAPE_COLUMN_TOP;
                }
                case PILLAR: {
                    return SHAPE_PILLAR;
                }
                case COLUMN: {
                    return SHAPE_COLUMN;
                }
            }
            return SHAPE_DEFAULT;
        }
        return VoxelShapes.func_197868_b();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.PEDESTAL.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K || !state.func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        if (!this.isPlaceable(state)) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)tileEntity;
            if (pedestal.isEmpty()) {
                ItemStack itemStack = player.func_184586_b(handIn);
                if (itemStack.func_190926_b()) {
                    return ActionResultType.CONSUME;
                }
                pedestal.setStack(player.field_71075_bZ.field_75098_d ? itemStack.func_77946_l().func_77979_a(1) : itemStack.func_77979_a(1));
                return ActionResultType.SUCCESS;
            }
            ItemStack itemStack = pedestal.getStack();
            if (player.func_191521_c(itemStack)) {
                pedestal.removeStack(worldIn, state);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof PedestalTileEntity) {
                PedestalTileEntity pedestal = (PedestalTileEntity)tileentity;
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)pedestal.getStack());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        boolean upSideSolid = upState.func_224755_d((IBlockReader)world, pos.func_177984_a(), Direction.DOWN) || upState.func_235714_a_((ITag)BlockTags.field_219757_z);
        boolean hasPedestalOver = upState.func_177230_c() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.func_177230_c() instanceof PedestalBlock;
        if (!hasPedestalOver && hasPedestalUnder && upSideSolid) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.COLUMN_TOP));
        }
        if (!hasPedestalOver && !hasPedestalUnder && upSideSolid) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.COLUMN));
        }
        if (hasPedestalUnder && hasPedestalOver) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.PILLAR));
        }
        if (hasPedestalUnder) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.PEDESTAL_TOP));
        }
        if (hasPedestalOver) {
            return (BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.BOTTOM));
        }
        return this.func_176223_P();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState updated = this.getUpdatedState(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!updated.func_203425_a((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            this.moveStoredStack(worldIn, updated, currentPos);
        }
        return updated;
    }

    private BlockState getUpdatedState(BlockState state, Direction direction, BlockState newState, IWorld world, BlockPos pos, BlockPos posFrom) {
        if (!state.func_203425_a((Block)this)) {
            return state.func_196956_a(direction, newState, world, pos, posFrom);
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        BlockState upState = world.func_180495_p(pos.func_177984_a());
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        boolean upSideSolid = upState.func_224755_d((IBlockReader)world, pos.func_177984_a(), Direction.DOWN) || upState.func_235714_a_((ITag)BlockTags.field_219757_z);
        boolean hasPedestalOver = upState.func_177230_c() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.func_177230_c() instanceof PedestalBlock;
        if (direction == Direction.UP) {
            upSideSolid = newState.func_224755_d((IBlockReader)world, posFrom, Direction.DOWN) || newState.func_235714_a_((ITag)BlockTags.field_219757_z);
            hasPedestalOver = newState.func_177230_c() instanceof PedestalBlock;
        } else if (direction == Direction.DOWN) {
            hasPedestalUnder = newState.func_177230_c() instanceof PedestalBlock;
        }
        if (!hasPedestalOver && hasPedestalUnder && upSideSolid) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.COLUMN_TOP));
        }
        if (!hasPedestalOver && !hasPedestalUnder && upSideSolid) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.COLUMN));
        }
        if (hasPedestalUnder && hasPedestalOver) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.PILLAR));
        }
        if (hasPedestalUnder) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.PEDESTAL_TOP));
        }
        if (hasPedestalOver) {
            return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.BOTTOM));
        }
        return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)BlockProperties.PedestalState.DEFAULT));
    }

    private void moveStoredStack(IWorld world, BlockState state, BlockPos pos) {
        ItemStack stack = ItemStack.field_190927_a;
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof PedestalTileEntity && state.func_203425_a((Block)this)) {
            PedestalTileEntity pedestal = (PedestalTileEntity)blockEntity;
            stack = pedestal.getStack();
            pedestal.clear();
            BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, (BlockState)state.func_206870_a((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false)));
        }
        if (!stack.func_190926_b()) {
            BlockPos upPos = pos.func_177984_a();
            this.moveStoredStack(world, stack, world.func_180495_p(upPos), upPos);
        }
    }

    private void moveStoredStack(IWorld world, ItemStack stack, BlockState state, BlockPos pos) {
        TileEntity blockEntity = world.func_175625_s(pos);
        if (!state.func_203425_a((Block)this)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (((BlockProperties.PedestalState)((Object)state.func_177229_b(STATE))).equals((Object)BlockProperties.PedestalState.PILLAR)) {
            BlockPos upPos = pos.func_177984_a();
            this.moveStoredStack(world, stack, world.func_180495_p(upPos), upPos);
        } else if (!this.isPlaceable(state)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (blockEntity instanceof PedestalTileEntity) {
            PedestalTileEntity pedestal = (PedestalTileEntity)blockEntity;
            if (pedestal.isEmpty()) {
                pedestal.setStack(stack);
            } else {
                this.dropStoredStack(blockEntity, stack, pos);
            }
        } else {
            this.dropStoredStack(blockEntity, stack, pos);
        }
    }

    private void dropStoredStack(TileEntity tileEntity, ItemStack stack, BlockPos pos) {
        if (tileEntity != null && tileEntity.func_145831_w() != null) {
            World world = tileEntity.func_145831_w();
            Block.func_180635_a((World)world, (BlockPos)this.getDropPos((IWorld)world, pos), (ItemStack)stack);
        }
    }

    private BlockPos getDropPos(IWorld world, BlockPos pos) {
        for (int i = 2; i < Direction.values().length; ++i) {
            BlockPos dropPos = pos.func_177972_a(Direction.func_82600_a((int)i));
            if (!world.func_180495_p(dropPos).func_196958_f()) continue;
            return dropPos.func_185334_h();
        }
        if (world.func_180495_p(pos.func_177984_a()).func_196958_f()) {
            return pos.func_177984_a();
        }
        return this.getDropPos(world, pos.func_177984_a());
    }

    protected boolean isPlaceable(BlockState state) {
        if (!state.func_203425_a((Block)this)) {
            return false;
        }
        BlockProperties.PedestalState currentState = (BlockProperties.PedestalState)((Object)state.func_177229_b(STATE));
        return currentState != BlockProperties.PedestalState.BOTTOM && currentState != BlockProperties.PedestalState.COLUMN && currentState != BlockProperties.PedestalState.PILLAR && currentState != BlockProperties.PedestalState.COLUMN_TOP;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE, HAS_ITEM, HAS_LIGHT});
    }

    public boolean func_149740_M(BlockState state) {
        return state.func_177230_c() instanceof PedestalBlock;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((Property)HAS_ITEM) != false ? 15 : 0;
    }

    static {
        VoxelShape basinUp = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape basinDown = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape columnTopUp = Block.func_208617_a((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        VoxelShape columnTopDown = Block.func_208617_a((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        VoxelShape pedestalTop = Block.func_208617_a((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        VoxelShape pedestalDefault = Block.func_208617_a((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape pillar = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        VoxelShape pillarDefault = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        VoxelShape columnTop = VoxelShapes.func_197872_a((VoxelShape)columnTopDown, (VoxelShape)columnTopUp);
        VoxelShape basin = VoxelShapes.func_197872_a((VoxelShape)basinDown, (VoxelShape)basinUp);
        SHAPE_PILLAR = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        SHAPE_DEFAULT = VoxelShapes.func_216384_a((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{pillarDefault, pedestalDefault});
        SHAPE_PEDESTAL_TOP = VoxelShapes.func_197872_a((VoxelShape)pillar, (VoxelShape)pedestalTop);
        SHAPE_COLUMN_TOP = VoxelShapes.func_197872_a((VoxelShape)SHAPE_PILLAR, (VoxelShape)columnTop);
        SHAPE_COLUMN = VoxelShapes.func_216384_a((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{SHAPE_PILLAR, columnTop});
        SHAPE_BOTTOM = VoxelShapes.func_197872_a((VoxelShape)basin, (VoxelShape)SHAPE_PILLAR);
    }
}

