/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModParticleTypes;
import mod.beethoven92.betterendforge.common.tileentity.HydrothermalVentTileEntity;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HydrothermalVentBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty ACTIVATED = BlockProperties.ACTIVATED;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HydrothermalVentBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HydrothermalVentTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (worldIn instanceof ServerWorld && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150355_j)) {
            this.func_225542_b_(state, (ServerWorld)worldIn, pos, worldIn.field_73012_v);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_203425_a((Block)ModBlocks.SULPHURIC_ROCK.stone.get());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockPos = context.func_195995_a();
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(blockPos).func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150355_j.func_176223_P();
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue() && facing == Direction.UP && facingState.func_203425_a(Blocks.field_150355_j)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 20);
        }
        return stateIn;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((Property)ACTIVATED)).booleanValue() && rand.nextBoolean()) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + 0.9 + rand.nextDouble() * 0.3;
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                worldIn.func_195594_a((IParticleData)ModParticleTypes.GEYSER_PARTICLE.get(), x, y, z, 0.0, 0.0, 0.0);
            } else {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos up = pos.func_177984_a();
        if (worldIn.func_180495_p(up).func_203425_a(Blocks.field_150355_j)) {
            BlockHelper.setWithoutUpdate((IWorldWriter)worldIn, up, (Block)ModBlocks.VENT_BUBBLE_COLUMN.get());
            worldIn.func_205220_G_().func_205360_a(up, (Object)ModBlocks.VENT_BUBBLE_COLUMN.get(), 5);
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, ACTIVATED});
    }
}

