/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class EndCrystalRenderer {
    private static final ResourceLocation CRYSTAL_TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    private static final ResourceLocation CRYSTAL_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final RenderType CRYSTAL_BEAM_LAYER;
    private static final RenderType END_CRYSTAL;
    private static final ModelRenderer CORE;
    private static final ModelRenderer FRAME;
    private static final int AGE_CYCLE = 240;
    private static final float SINE_45_DEGREES;

    public static void render(int age, int maxAge, float tickDelta, MatrixStack matrices, IRenderTypeBuffer bufferIn, int light) {
        float k = 240.0f / (float)maxAge;
        float rotation = ((float)age * k + tickDelta) * 3.0f;
        IVertexBuilder iVertexBuilder = bufferIn.getBuffer(END_CRYSTAL);
        matrices.func_227860_a_();
        matrices.func_227862_a_(0.8f, 0.8f, 0.8f);
        matrices.func_227861_a_(0.0, -0.5, 0.0);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        matrices.func_227861_a_(0.0, (double)0.8f, 0.0);
        matrices.func_227863_a_(new Quaternion(new Vector3f(SINE_45_DEGREES, 0.0f, SINE_45_DEGREES), 60.0f, true));
        FRAME.func_228308_a_(matrices, iVertexBuilder, light, OverlayTexture.field_229196_a_);
        matrices.func_227862_a_(0.875f, 0.875f, 0.875f);
        matrices.func_227863_a_(new Quaternion(new Vector3f(SINE_45_DEGREES, 0.0f, SINE_45_DEGREES), 60.0f, true));
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        FRAME.func_228308_a_(matrices, iVertexBuilder, light, OverlayTexture.field_229196_a_);
        matrices.func_227862_a_(0.875f, 0.875f, 0.875f);
        matrices.func_227863_a_(new Quaternion(new Vector3f(SINE_45_DEGREES, 0.0f, SINE_45_DEGREES), 60.0f, true));
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        CORE.func_228308_a_(matrices, iVertexBuilder, light, OverlayTexture.field_229196_a_);
        matrices.func_227865_b_();
    }

    public static void renderBeam(BlockPos start, BlockPos end, float tickDelta, int age, MatrixStack matrices, IRenderTypeBuffer bufferIn, int light) {
        float dx = (float)(start.func_177958_n() - end.func_177958_n()) + 1.0f;
        float dy = (float)(start.func_177956_o() - end.func_177956_o()) + 1.0f;
        float dz = (float)(start.func_177952_p() - end.func_177952_p()) + 1.0f;
        float f = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
        float g = MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz));
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 2.0, 0.0);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrices.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(f, dy)) - 1.5707964f));
        IVertexBuilder iVertexBuilder = bufferIn.getBuffer(CRYSTAL_BEAM_LAYER);
        float h = 0.0f - ((float)age + tickDelta) * 0.01f;
        float i = MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz)) / 32.0f - ((float)age + tickDelta) * 0.01f;
        float k = 0.0f;
        float l = 0.75f;
        float m = 0.0f;
        MatrixStack.Entry entry = matrices.func_227866_c_();
        Matrix4f matrix4f = entry.func_227870_a_();
        Matrix3f matrix3f = entry.func_227872_b_();
        for (int n = 1; n <= 8; ++n) {
            float o = MathHelper.func_76126_a((float)((float)n * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float p = MathHelper.func_76134_b((float)((float)n * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float q = (float)n / 8.0f;
            iVertexBuilder.func_227888_a_(matrix4f, k * 0.2f, l * 0.2f, 0.0f).func_225586_a_(0, 0, 0, 255).func_225583_a_(m, h).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            iVertexBuilder.func_227888_a_(matrix4f, k, l, g).func_225586_a_(255, 255, 255, 255).func_225583_a_(m, i).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            iVertexBuilder.func_227888_a_(matrix4f, o, p, g).func_225586_a_(255, 255, 255, 255).func_225583_a_(q, i).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            iVertexBuilder.func_227888_a_(matrix4f, o * 0.2f, p * 0.2f, 0.0f).func_225586_a_(0, 0, 0, 255).func_225583_a_(q, h).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            k = o;
            l = p;
            m = q;
        }
        matrices.func_227865_b_();
    }

    static {
        END_CRYSTAL = RenderType.func_228640_c_((ResourceLocation)CRYSTAL_TEXTURE);
        CRYSTAL_BEAM_LAYER = RenderType.func_228646_f_((ResourceLocation)CRYSTAL_BEAM_TEXTURE);
        SINE_45_DEGREES = (float)Math.sin(0.7853981633974483);
        FRAME = new ModelRenderer(64, 32, 0, 0);
        FRAME.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        CORE = new ModelRenderer(64, 32, 32, 0);
        CORE.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
    }
}

