/*
 * Decompiled with CFR 0.152.
 */
package seleneandmana.compatoplenty.core.registry.util;

import com.minecraftabnormals.abnormals_core.client.ChestManager;
import com.minecraftabnormals.abnormals_core.client.renderer.ChestItemRenderer;
import com.minecraftabnormals.abnormals_core.common.blocks.chest.AbnormalsChestBlock;
import com.minecraftabnormals.abnormals_core.common.blocks.chest.AbnormalsTrappedChestBlock;
import com.minecraftabnormals.abnormals_core.common.tileentity.AbnormalsChestTileEntity;
import com.minecraftabnormals.abnormals_core.common.tileentity.AbnormalsTrappedChestTileEntity;
import com.minecraftabnormals.abnormals_core.core.util.registry.BlockSubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.mojang.datafixers.util.Pair;
import java.util.concurrent.Callable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;

public class CompatBlockSubRegistryHelper
extends BlockSubRegistryHelper {
    public CompatBlockSubRegistryHelper(RegistryHelper parent) {
        super(parent);
    }

    public Pair<RegistryObject<AbnormalsChestBlock>, RegistryObject<AbnormalsTrappedChestBlock>> createUnburnableCompatChestBlocks(String compatModId, String name, MaterialColor color) {
        boolean isModLoaded = ModList.get().isLoaded(compatModId) || compatModId == "indev";
        ItemGroup chestGroup = isModLoaded ? ItemGroup.field_78031_c : null;
        ItemGroup trappedChestGroup = isModLoaded ? ItemGroup.field_78028_d : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new AbnormalsChestBlock(modId + ":" + name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new AbnormalsTrappedChestBlock(modId + ":" + name + "_trapped", AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        this.itemRegister.register(chestName, () -> new BlockItem((Block)chest.get(), new Item.Properties().func_200916_a(chestGroup).setISTER(() -> CompatBlockSubRegistryHelper.chestISTER(false))));
        this.itemRegister.register(trappedChestName, () -> new BlockItem((Block)trappedChest.get(), new Item.Properties().func_200916_a(trappedChestGroup).setISTER(() -> CompatBlockSubRegistryHelper.chestISTER(true))));
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)false);
        ChestManager.putChestInfo((String)modId, (String)name, (boolean)true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> chestISTER(boolean trapped) {
        return () -> new ChestItemRenderer(trapped ? AbnormalsTrappedChestTileEntity::new : AbnormalsChestTileEntity::new);
    }
}

