/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.mojang.serialization.Codec;
import corgiaoc.byg.core.world.BYGSurfaceBuilders;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class CanyonSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long seed;
    protected FastNoise noiseGen = null;
    protected FastNoise noiseGen2 = null;
    protected FastNoise noiseGen3 = null;
    protected FastNoise noiseGen4 = null;
    protected FastNoise noiseGen5 = null;
    protected FastNoise noiseGen6 = null;
    public BlockState layerBlock = Blocks.field_150405_ch.func_176223_P();

    public CanyonSB(Codec<SurfaceBuilderConfig> config) {
        super(config);
    }

    public void apply(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int groundHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.func_205548_a(seed);
        BlockPos.Mutable block = new BlockPos.Mutable();
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        double canyonShapingNoise1 = this.noiseGen.GetNoise(x, z) * 10.0f;
        double canyonShapingNoise2 = this.noiseGen6.GetNoise(x, z) * 10.0f;
        double noiseSample2 = this.noiseGen2.GetNoise(x, z);
        double noiseSample3 = this.noiseGen3.GetNoise(x, z);
        double noiseSample4 = this.noiseGen4.GetNoise((float)x * 1.1f, (float)z * 1.34f);
        double totalNoiseSample = noiseSample2 * 15.0 + noiseSample3 * 9.0 * noiseSample3;
        double simulateErosion = Math.abs(noiseSample2 * 8.0 + noiseSample4 * (4.0 + noiseSample2 * 3.0));
        if (canyonShapingNoise2 > 9.0) {
            int yPos = groundHeight;
            while ((double)yPos >= (double)seaLevel - totalNoiseSample) {
                block.func_181079_c(xPos, yPos, zPos);
                double noiseSample5 = this.noiseGen5.GetNoise((float)x * 1.1f, yPos, (float)z * 1.34f);
                if (canyonShapingNoise2 < 9.06) {
                    if ((double)yPos < (double)(groundHeight - 10) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.12) {
                    if ((double)yPos < (double)(groundHeight - 13) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.18) {
                    if ((double)yPos < (double)(groundHeight - 16) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.24) {
                    if ((double)yPos < (double)(groundHeight - 19) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.45) {
                    if ((double)yPos < (double)(groundHeight - 22) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.51) {
                    if ((double)yPos < (double)(groundHeight - 32) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.57) {
                    if ((double)yPos < (double)(groundHeight - 35) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.63) {
                    if ((double)yPos < (double)(groundHeight - 38) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (canyonShapingNoise2 < 9.69) {
                    if ((double)yPos < (double)(groundHeight - 41) - simulateErosion - noiseSample5 * 6.0) {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150348_b.func_176223_P(), false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                    }
                } else if (yPos >= seaLevel - 1) {
                    chunkIn.func_177436_a((BlockPos)block, Blocks.field_150350_a.func_176223_P(), false);
                }
                --yPos;
            }
        }
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, groundHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)config);
        for (int y = seaLevel - 1; y >= seaLevel - 20; --y) {
            block.func_181079_c(xPos, y, zPos);
            if (!chunkIn.func_180495_p((BlockPos)block).func_196958_f()) continue;
            chunkIn.func_177436_a((BlockPos)block, Blocks.field_150355_j.func_176223_P(), false);
            chunkIn.func_212247_j().func_205360_a((BlockPos)block, (Object)Fluids.field_204546_a, 0);
        }
    }

    public void func_205548_a(long seed) {
        if (this.noiseGen == null) {
            this.noiseGen = new FastNoise((int)seed);
            this.noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            this.noiseGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.noiseGen.SetGradientPerturbAmp(1.0f);
            this.noiseGen.SetFractalOctaves(1);
            this.noiseGen.SetFractalGain(0.3f);
            this.noiseGen.SetFrequency(0.0012f);
        }
        if (this.noiseGen2 == null) {
            this.noiseGen2 = new FastNoise((int)seed + 20);
            this.noiseGen2.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.noiseGen2.SetFractalOctaves(2);
            this.noiseGen2.SetFractalGain(0.3f);
            this.noiseGen2.SetFrequency(0.01f);
        }
        if (this.noiseGen3 == null) {
            this.noiseGen3 = new FastNoise((int)seed + 277);
            this.noiseGen3.SetNoiseType(FastNoise.NoiseType.ValueFractal);
            this.noiseGen3.SetFractalOctaves(1);
            this.noiseGen3.SetFractalGain(0.3f);
            this.noiseGen3.SetFrequency(0.004f);
        }
        if (this.noiseGen4 == null) {
            this.noiseGen4 = new FastNoise((int)seed + 234233);
            this.noiseGen4.SetNoiseType(FastNoise.NoiseType.ValueFractal);
            this.noiseGen4.SetFractalOctaves(1);
            this.noiseGen4.SetFractalGain(0.3f);
            this.noiseGen4.SetFrequency(0.01f);
        }
        if (this.noiseGen5 == null) {
            this.noiseGen5 = new FastNoise((int)seed + 234233);
            this.noiseGen5.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.noiseGen5.SetFractalOctaves(1);
            this.noiseGen5.SetFractalGain(0.3f);
            this.noiseGen5.SetFrequency(0.001f);
        }
        if (this.noiseGen6 == null) {
            this.noiseGen6 = new FastNoise((int)seed + 395958);
            this.noiseGen6.SetFractalType(FastNoise.FractalType.RigidMulti);
            this.noiseGen6.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.noiseGen6.SetGradientPerturbAmp(1.0f);
            this.noiseGen6.SetFractalOctaves(1);
            this.noiseGen6.SetFractalGain(0.3f);
            this.noiseGen6.SetFrequency(0.0012f);
        }
    }

    public static SurfaceBuilderConfig randomSurfaceConfig(Random random) {
        int randomizer = random.nextInt(7);
        if (randomizer == 1) {
            return BYGSurfaceBuilders.Configs.GRASSMOUNTAIN_CF;
        }
        if (randomizer == 2 || randomizer == 3) {
            return BYGSurfaceBuilders.Configs.GRASSMOUNTAIN_CF;
        }
        return BYGSurfaceBuilders.Configs.GRASSMOUNTAIN_CF;
    }

    public void setStrataLayerBlock(int yPos) {
        if (yPos % 5 == 0) {
            this.layerBlock = Blocks.field_196604_cC.func_176223_P();
        } else if (yPos % 2 == 0) {
            this.layerBlock = Blocks.field_150403_cj.func_176223_P();
        } else if (yPos % 7 == 0) {
            this.layerBlock = Blocks.field_205164_gk.func_176223_P();
        }
    }
}

