/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.gen.feature.tree.TreePlacerTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class PalmTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<PalmTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(tp -> tp.field_236906_d_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(tp -> tp.field_236907_e_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(tp -> tp.field_236908_f_), (App)Codec.FLOAT.fieldOf("ophidian_tongue_chance").forGetter(tp -> Float.valueOf(tp.ophidianTongueChance))).apply((Applicative)instance, PalmTrunkPlacer::new));
    private final float ophidianTongueChance;

    public PalmTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, float ophidianTongueChance) {
        super(baseHeight, heightRandA, heightRandB);
        this.ophidianTongueChance = ophidianTongueChance;
    }

    @Nonnull
    protected TrunkPlacerType<?> func_230381_a_() {
        return TreePlacerTypes.PALM_Trunk;
    }

    @Nonnull
    public List<FoliagePlacer.Foliage> func_230382_a_(@Nonnull IWorldGenerationReader genReader, @Nonnull Random rand, int amount, @Nonnull BlockPos pos, @Nonnull Set<BlockPos> logs, @Nonnull MutableBoundingBox box, @Nonnull BaseTreeFeatureConfig config) {
        for (int i = 0; i < amount; ++i) {
            BlockPos placePos = pos.func_177981_b(i);
            this.placeLogWithOphidian(genReader, rand, placePos, logs, box, config);
        }
        return ImmutableList.of((Object)new FoliagePlacer.Foliage(pos.func_177981_b(amount), 0, false));
    }

    protected boolean placeLogWithOphidian(IWorldGenerationReader genReader, Random rand, BlockPos pos, Set<BlockPos> logs, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)genReader, (BlockPos)pos)) {
            PalmTrunkPlacer.func_236913_a_((IWorldWriter)genReader, (BlockPos)pos, (BlockState)config.field_227368_m_.func_225574_a_(rand, pos), (MutableBoundingBox)box);
            logs.add(pos.func_185334_h());
            if (this.ophidianTongueChance > 0.0f && rand.nextDouble() <= (double)this.ophidianTongueChance) {
                BlockPos genPos;
                HashSet set = Sets.newHashSet();
                if (rand.nextInt(8) == 0 && PalmTrunkPlacer.isAirAt((IWorldGenerationBaseReader)genReader, genPos = pos.func_177976_e())) {
                    this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176278_M, set, box);
                }
                if (rand.nextInt(8) == 0 && PalmTrunkPlacer.isAirAt((IWorldGenerationBaseReader)genReader, genPos = pos.func_177974_f())) {
                    this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176280_O, set, box);
                }
                if (rand.nextInt(8) == 0 && PalmTrunkPlacer.isAirAt((IWorldGenerationBaseReader)genReader, genPos = pos.func_177978_c())) {
                    this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176279_N, set, box);
                }
                if (rand.nextInt(8) == 0 && PalmTrunkPlacer.isAirAt((IWorldGenerationBaseReader)genReader, genPos = pos.func_177968_d())) {
                    this.addOphidianTongueToTree(genReader, genPos, VineBlock.field_176273_b, set, box);
                }
            }
            return true;
        }
        return false;
    }

    private void addOphidianTongueToTree(IWorldGenerationReader seedReader, BlockPos pos, BooleanProperty booleanProperty, Set<BlockPos> positions, MutableBoundingBox mutableBox) {
        this.generateOphidianTongue((IWorldWriter)seedReader, pos, booleanProperty, positions, mutableBox);
        pos = pos.func_177977_b();
        for (int i = 4; PalmTrunkPlacer.isAirAt((IWorldGenerationBaseReader)seedReader, pos) && i > 0; --i) {
            this.generateOphidianTongue((IWorldWriter)seedReader, pos, booleanProperty, positions, mutableBox);
            pos = pos.func_177977_b();
        }
    }

    protected void generateOphidianTongue(IWorldWriter world, BlockPos pos, BooleanProperty booleanProperty, Set<BlockPos> positions, MutableBoundingBox mutableBox) {
        this.setOphidianTongue(world, pos, (BlockState)AtumBlocks.OPHIDIAN_TONGUE.func_176223_P().func_206870_a((Property)booleanProperty, (Comparable)Boolean.valueOf(true)), positions, mutableBox);
    }

    protected void setOphidianTongue(IWorldWriter worldWriter, BlockPos pos, BlockState state, Set<BlockPos> positions, MutableBoundingBox mutableBox) {
        worldWriter.func_180501_a(pos, state, 19);
        positions.add(pos);
        mutableBox.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
    }

    public static boolean isAirAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, ab -> ab.func_196958_f());
    }
}

