/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.DimensionHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class StartStructureFeature
extends Feature<NoFeatureConfig> {
    public StartStructureFeature(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(@Nonnull ISeedReader seedReader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        if (seedReader instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)seedReader;
            TemplateManager manager = serverWorld.func_184163_y();
            Template template = manager.func_200219_b(new ResourceLocation((String)AtumConfig.ATUM_START.atumStartStructure.get()));
            if (template != null) {
                Rotation[] rotations = Rotation.values();
                Rotation rotation = rotations[rand.nextInt(rotations.length)];
                PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_189950_a(rand);
                BlockPos rotatedPos = template.func_186257_a(rotation);
                int x = rand.nextInt(rotatedPos.func_177958_n()) + template.func_186259_a().func_177958_n();
                int z = rand.nextInt(rotatedPos.func_177952_p()) + template.func_186259_a().func_177952_p();
                BlockPos posOffset = DimensionHelper.getSurfacePos((World)serverWorld, pos.func_177982_a(x, 0, z));
                template.func_237146_a_((IServerWorld)serverWorld, posOffset, posOffset.func_177977_b(), settings, rand, 20);
                return true;
            }
            Atum.LOG.error((String)AtumConfig.ATUM_START.atumStartStructure.get() + " is not a valid structure");
            return false;
        }
        return false;
    }
}

