/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.blocks.SandLayersBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.DimensionHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SandLayerFeature
extends Feature<NoFeatureConfig> {
    public SandLayerFeature(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(@Nonnull ISeedReader seedReader, @Nonnull ChunkGenerator chunkGenerator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int x = pos.func_177958_n() + i;
                int z = pos.func_177952_p() + j;
                int y = seedReader.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z);
                mutablePos.func_181079_c(x, y, z);
                for (Direction facing : Direction.Plane.HORIZONTAL) {
                    BlockPos posOffset = mutablePos.func_177972_a(facing);
                    if (!seedReader.func_180495_p(posOffset).func_224755_d((IBlockReader)seedReader, posOffset, Direction.UP) || !DimensionHelper.canPlaceSandLayer(seedReader, (BlockPos)mutablePos)) continue;
                    int layers = MathHelper.func_76136_a((Random)rand, (int)1, (int)3);
                    seedReader.func_180501_a((BlockPos)mutablePos, (BlockState)AtumBlocks.SAND_LAYERED.func_176223_P().func_206870_a((Property)SandLayersBlock.LAYERS, (Comparable)Integer.valueOf(layers)), 2);
                }
            }
        }
        return true;
    }
}

