/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumLootTables;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BonusCrateFeature
extends Feature<NoFeatureConfig> {
    public BonusCrateFeature(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(@Nonnull ISeedReader seedReader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        ChunkPos chunkpos = new ChunkPos(pos);
        List xPositions = IntStream.rangeClosed(chunkpos.func_180334_c(), chunkpos.func_180332_e()).boxed().collect(Collectors.toList());
        Collections.shuffle(xPositions, rand);
        List zPositions = IntStream.rangeClosed(chunkpos.func_180333_d(), chunkpos.func_180330_f()).boxed().collect(Collectors.toList());
        Collections.shuffle(zPositions, rand);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (Integer x : xPositions) {
            for (Integer z : zPositions) {
                mutablePos.func_181079_c(x.intValue(), 0, z.intValue());
                BlockPos posHeight = seedReader.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutablePos);
                if (!seedReader.func_175623_d(posHeight) && !seedReader.func_180495_p(posHeight).func_196952_d((IBlockReader)seedReader, posHeight).func_197766_b()) continue;
                seedReader.func_180501_a(posHeight, AtumBlocks.DEADWOOD_CRATE.func_176223_P(), 2);
                LockableLootTileEntity.func_195479_a((IBlockReader)seedReader, (Random)rand, (BlockPos)posHeight, (ResourceLocation)AtumLootTables.CRATE_BONUS);
                BlockState torch = AtumBlocks.DEADWOOD_TORCH.func_176223_P();
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    BlockPos neighborPos = posHeight.func_177972_a(horizontal);
                    if (!torch.func_196955_c((IWorldReader)seedReader, neighborPos)) continue;
                    seedReader.func_180501_a(neighborPos, torch, 2);
                }
                return true;
            }
        }
        return false;
    }
}

