/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen;

import com.teammetallurgy.atum.api.AtumAPI;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.init.AtumStructures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.carver.AtumCarvers;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;

public class AtumDefaultFeatures {
    public static final RuleTest NATURAL_STONE = new TagMatchRuleTest(AtumAPI.Tags.BASE_STONE_ATUM);
    public static final RuleTest LIMESTONE_CRACKED = new BlockMatchRuleTest(AtumBlocks.LIMESTONE_CRACKED);

    public static void addCarvers(BiomeGenerationSettings.Builder builder) {
        builder.func_242512_a(GenerationStage.Carving.AIR, AtumCarvers.CAVE_CONFIGURED);
        builder.func_242512_a(GenerationStage.Carving.AIR, AtumCarvers.CANYON_CONFIGURED);
    }

    public static void addSandLayer(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, AtumFeatures.SAND_LAYER_CONFIGURED);
    }

    public static void addSurfaceLavaLake(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.LAKES, AtumFeatures.SURFACE_LAVA_LAKE_CONFIGURED);
    }

    public static void addSprings(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.WATER_SPRING);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.LAVA_SPRING);
    }

    public static void addMaterialPockets(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.sandCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.SAND);
        }
        if ((Integer)AtumConfig.WORLD_GEN.limestoneGravelCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.LIMESTONE_GRAVEL);
        }
        if ((Integer)AtumConfig.WORLD_GEN.marlCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.MARL);
        }
    }

    public static void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.alabasterCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.ALABASTER);
        }
        if ((Integer)AtumConfig.WORLD_GEN.porphyryCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.PORPHYRY);
        }
    }

    public static void addOres(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.coalCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.COAL_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.ironCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.IRON_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.goldCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.GOLD_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.redstoneCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.REDSTONE_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.diamondCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.DIAMOND_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.lapisBaseline.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.LAPIS_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.khnumiteCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.KHNUMITE_RAW);
        }
        if ((Integer)AtumConfig.WORLD_GEN.boneOreCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.BONE_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.relicOreCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.RELIC_ORE);
        }
        if ((Integer)AtumConfig.WORLD_GEN.nebuCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.NEBU_ORE);
        }
    }

    public static void addEmeraldOre(BiomeGenerationSettings.Builder builder) {
        if (((Boolean)AtumConfig.WORLD_GEN.emeraldEnabled.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.EMERALD_ORE);
        }
    }

    public static void addInfestedLimestone(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, AtumFeatures.LIMESTONE_INFESTED);
    }

    public static void addShrubs(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.SHRUB);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.WEED);
        }
    }

    public static void addFossils(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.fossilsChance.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, AtumFeatures.DIRTY_BONE_FOSSILS_CONFIGURED);
        }
    }

    public static void addDungeon(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.dungeonChance.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, AtumFeatures.LIMESTONE_DUNGEONS_CONFIGURED);
        }
    }

    public static void addTomb(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.TOMB_FEATURE);
    }

    public static void addPyramid(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.PYRAMID_FEATURE);
    }

    public static void addRuins(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.RUIN_FEATURE);
    }

    public static void addGatehouse(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.GATEHOUSE_FEATURE);
    }

    public static void addGenericVillage(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.GENERIC_VILLAGE);
    }

    public static void addMineshaft(BiomeGenerationSettings.Builder builder, boolean isSurface) {
        if ((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get() > 0.0) {
            if (isSurface) {
                builder.func_242516_a(AtumStructures.MINESHAFT_DEADWOOD_SURFACE_FEATURE);
                builder.func_242516_a(AtumStructures.MINESHAFT_LIMESTONE_SURFACE_FEATURE);
            } else {
                builder.func_242516_a(AtumStructures.MINESHAFT_DEADWOOD_FEATURE);
                builder.func_242516_a(AtumStructures.MINESHAFT_LIMESTONE_FEATURE);
            }
        }
    }
}

