/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.world.WorldSeedHolder;
import com.teammetallurgy.atum.world.gen.layer.AtumLayerUtil;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AtumBiomeProvider
extends BiomeProvider {
    public static final Codec<AtumBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(atumBiomeProvider -> atumBiomeProvider.largeBiomes), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(atumBiomeProvider -> atumBiomeProvider.lookupRegistry), (App)Codec.LONG.fieldOf("seed").orElseGet(WorldSeedHolder::getSeed).forGetter(chunkGenerator -> chunkGenerator.seed)).apply((Applicative)builder, builder.stable(AtumBiomeProvider::new)));
    private final Layer genBiomes;
    private final boolean largeBiomes;
    private final Registry<Biome> lookupRegistry;
    private final long seed;

    public AtumBiomeProvider(boolean largeBiomes, Registry<Biome> lookupRegistry, long seed) {
        super(AtumRegistry.BIOME_KEYS.stream().map(arg_0 -> lookupRegistry.func_243576_d(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.largeBiomes = largeBiomes;
        this.lookupRegistry = lookupRegistry;
        this.genBiomes = AtumLayerUtil.getNoiseLayer(seed, largeBiomes ? 6 : 4, 6, lookupRegistry);
    }

    @Nonnull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new AtumBiomeProvider(this.largeBiomes, this.lookupRegistry, this.seed);
    }

    @Nonnull
    public Biome func_225526_b_(int x, int y, int z) {
        int k = this.genBiomes.field_215742_b.func_202678_a(x, z);
        Biome biome = (Biome)this.lookupRegistry.func_148745_a(k);
        if (biome != null) {
            return biome;
        }
        if (SharedConstants.field_206244_b) {
            throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Unknown biome id: " + k));
        }
        biome = (Biome)this.lookupRegistry.func_230516_a_(BiomeRegistry.func_244203_a((int)0));
        if (biome == null) {
            return BiomeRegistry.field_244201_b;
        }
        return biome;
    }
}

