/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome;

import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.init.AtumStructures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.DimensionHelper;
import com.teammetallurgy.atum.world.gen.AtumDefaultFeatures;
import com.teammetallurgy.atum.world.gen.AtumSurfaceBuilders;
import com.teammetallurgy.atum.world.gen.carver.AtumCarvers;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;

public class AtumBiomeMaker {
    public static Biome makeDeadOasis(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.GRAVEL_CRACKED);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.SPARSE_DRY_GRASS_SPREAD_5);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEAD_PALM_TREE);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumBiomeMaker.addCamelSpawning(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addSurfaceLavaLake(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addShrubs(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addPyramid(biomeGen);
        AtumDefaultFeatures.addRuins(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_205421_a(-0.18f).func_205420_b(0.0f).func_242457_a(biomeGen.func_242508_a()).func_242458_a(new MobSpawnInfo.Builder().func_242571_a().func_242577_b()).func_235097_a_(Builder.getBaseEffects().func_242540_e(10189386).func_242541_f(10189386).func_235238_a_()).func_242455_a();
    }

    public static Biome makeSparseWoods(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.SPARSE_DRY_GRASS_NOISE_08_2_3);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.SPARSE_TALL_GRASS);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_3_01_1);
        return AtumBiomeMaker.makeBaseWoods(biomeName, biomeGen);
    }

    public static Biome makeDenseWoods(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DENSE_DRY_GRASS_NOISE_08_5_10);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DRY_TALL_GRASS);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_20_025_3);
        return AtumBiomeMaker.makeBaseWoods(biomeName, biomeGen);
    }

    private static Biome makeBaseWoods(String biomeName, BiomeGenerationSettings.Builder biomeGen) {
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.ANPUTS_FINGERS_CONFIGURED);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addSurfaceLavaLake(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addShrubs(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addPyramid(biomeGen);
        AtumDefaultFeatures.addRuins(biomeGen);
        AtumDefaultFeatures.addGatehouse(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(new MobSpawnInfo.Builder().func_242571_a().func_242577_b()).func_242455_a();
    }

    public static Biome makeDriedRiver(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.GRAVEL_CRACKED);
        biomeGen.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AtumFeatures.MARL_DRIED_RIVER);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addSurfaceLavaLake(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addShrubs(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(MobSpawnInfo.field_242551_b).func_205421_a(-0.28f).func_205420_b(0.0f).func_242455_a();
    }

    public static Biome makeLimestoneCrags(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY);
        biomeGen.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, AtumFeatures.LIMESTONE_SPIKE_CONFIGURED);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_0_02_1);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumBiomeMaker.addDesertWolfSpawning(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addSurfaceLavaLake(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addEmeraldOre(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(MobSpawnInfo.field_242551_b).func_205421_a(0.75f).func_205420_b(0.45f).func_242455_a();
    }

    public static Biome makeLimestoneMountain(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY_LIMESTONE);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_0_01_1);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumBiomeMaker.addDesertWolfSpawning(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addEmeraldOre(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addRuins(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, true);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(MobSpawnInfo.field_242551_b).func_205421_a(1.5f).func_205420_b(0.6f).func_242455_a();
    }

    public static Biome makeOasis(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.OASIS);
        biomeGen.func_242512_a(GenerationStage.Carving.AIR, AtumCarvers.CAVE_CONFIGURED);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.OASIS_GRASS);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.PAPYRUS);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.LILY_PAD);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.PALM_TREE);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.ACACIA_TREE);
        AtumBiomeMaker.addCamelSpawning(biomeName);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.QUAIL, 8, 2, 5, EntityClassification.CREATURE);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DENSE_DRY_GRASS_NOISE_08_5_10);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DRY_TALL_GRASS);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addEmeraldOre(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_205421_a(-0.45f).func_205420_b(0.0f).func_205414_c(1.85f).func_242457_a(biomeGen.func_242508_a()).func_242458_a(new MobSpawnInfo.Builder().func_242571_a().func_242577_b()).func_235097_a_(Builder.getBaseEffects().func_242540_e(11987573).func_242541_f(11987573).func_235246_b_(0x33CCCC).func_235248_c_(39321).func_235238_a_()).func_242455_a();
    }

    public static Biome makeSandDunes(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_0_01_1);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumBiomeMaker.addCamelSpawning(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addSurfaceLavaLake(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addShrubs(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addPyramid(biomeGen);
        AtumDefaultFeatures.addRuins(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(new MobSpawnInfo.Builder().func_242571_a().func_242577_b()).func_205421_a(0.175f).func_205420_b(0.2f).func_242455_a();
    }

    public static Biome makeSandHills(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_0_08_1);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumBiomeMaker.addDesertWolfSpawning(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addEmeraldOre(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addRuins(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(MobSpawnInfo.field_242551_b).func_205421_a(0.3f).func_205420_b(0.3f).func_242455_a();
    }

    public static Biome makeSandPlains(String biomeName) {
        BiomeGenerationSettings.Builder biomeGen = new BiomeGenerationSettings.Builder().func_242517_a(AtumSurfaceBuilders.SANDY);
        biomeGen.func_242516_a(AtumStructures.GIRAFI_TOMB_FEATURE);
        biomeGen.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_0_025_1);
        AtumBiomeMaker.addDefaultSpawns(biomeName);
        AtumBiomeMaker.addCamelSpawning(biomeName);
        AtumDefaultFeatures.addCarvers(biomeGen);
        AtumDefaultFeatures.addSandLayer(biomeGen);
        AtumDefaultFeatures.addSprings(biomeGen);
        AtumDefaultFeatures.addSurfaceLavaLake(biomeGen);
        AtumDefaultFeatures.addMaterialPockets(biomeGen);
        AtumDefaultFeatures.addStoneVariants(biomeGen);
        AtumDefaultFeatures.addOres(biomeGen);
        AtumDefaultFeatures.addInfestedLimestone(biomeGen);
        AtumDefaultFeatures.addShrubs(biomeGen);
        AtumDefaultFeatures.addFossils(biomeGen);
        AtumDefaultFeatures.addDungeon(biomeGen);
        AtumDefaultFeatures.addTomb(biomeGen);
        AtumDefaultFeatures.addPyramid(biomeGen);
        AtumDefaultFeatures.addRuins(biomeGen);
        AtumDefaultFeatures.addGatehouse(biomeGen);
        AtumDefaultFeatures.addMineshaft(biomeGen, false);
        AtumDefaultFeatures.addGenericVillage(biomeGen);
        return new Builder().func_242457_a(biomeGen.func_242508_a()).func_242458_a(new MobSpawnInfo.Builder().func_242571_a().func_242577_b()).func_242455_a();
    }

    public static void addDefaultSpawns(String biomeName) {
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.DESERT_RABBIT, 5, 2, 3, EntityClassification.CREATURE);
        AtumBiomeMaker.addSpawn(biomeName, EntityType.field_200791_e, 4, 4, 8, EntityClassification.AMBIENT);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.QUAIL, 3, 2, 4, EntityClassification.CREATURE);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.BONESTORM, 5, 1, 2, EntityClassification.MONSTER);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.FORSAKEN, 22, 1, 4, EntityClassification.MONSTER);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.MUMMY, 30, 1, 3, EntityClassification.MONSTER);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.WRAITH, 10, 1, 2, EntityClassification.MONSTER);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.STONEGUARD, 34, 1, 2, EntityClassification.MONSTER);
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.TARANTULA, 20, 1, 3, EntityClassification.MONSTER);
    }

    public static void addSpawn(String biomeName, EntityType<?> entityType, int weight, int min, int max, EntityClassification classification) {
        ResourceLocation location = entityType.getRegistryName();
        if (location != null) {
            new AtumConfig.Mobs(AtumConfig.BUILDER, location.func_110623_a(), min, max, weight, entityType, classification, new ResourceLocation("atum", biomeName));
        }
    }

    public static void addCamelSpawning(String biomeName) {
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.CAMEL, 6, 2, 6, EntityClassification.CREATURE);
    }

    public static void addDesertWolfSpawning(String biomeName) {
        AtumBiomeMaker.addSpawn(biomeName, AtumEntities.DESERT_WOLF, 6, 2, 4, EntityClassification.CREATURE);
    }

    public static class Builder
    extends Biome.Builder {
        public Builder() {
            this.func_205415_a(Biome.RainType.NONE);
            this.func_205419_a(Biome.Category.DESERT);
            this.func_205414_c(2.0f);
            this.func_205417_d(0.0f);
            this.func_235097_a_(Builder.getBaseEffects().func_235238_a_());
            this.func_205421_a(0.135f);
            this.func_205420_b(0.05f);
        }

        public static BiomeAmbience.Builder getBaseEffects() {
            return new BiomeAmbience.Builder().func_235239_a_(13876389).func_235246_b_(7036242).func_235248_c_(7036242).func_242539_d(DimensionHelper.getSkyColorWithTemperatureModifier(2.0f)).func_242541_f(12889745).func_242540_e(12889745).func_235243_a_(MoodSoundAmbience.field_235027_b_);
        }
    }
}

