/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.event;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.PortalBlock;
import com.teammetallurgy.atum.blocks.base.IUnbreakable;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.items.WandererDyeableArmor;
import com.teammetallurgy.atum.items.artifacts.atem.AtemsBountyItem;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.misc.StackHelper;
import com.teammetallurgy.atum.world.teleporter.TeleporterAtumStart;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtumEventListener {
    private static final String TAG_ATUM_START = "atum_start";

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        CompoundNBT tag = player.getPersistentData();
        CompoundNBT persistedTag = tag.func_74775_l("PlayerPersisted");
        boolean shouldStartInAtum = (Boolean)AtumConfig.ATUM_START.startInAtum.get() != false && !persistedTag.func_74767_n(TAG_ATUM_START);
        persistedTag.func_74757_a(TAG_ATUM_START, true);
        tag.func_218657_a("PlayerPersisted", (INBT)persistedTag);
        if (shouldStartInAtum && player instanceof ServerPlayerEntity && player.field_70170_p instanceof ServerWorld) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ServerWorld world = (ServerWorld)player.field_70170_p;
            PortalBlock.changeDimension(world, (Entity)serverPlayer, new TeleporterAtumStart());
            serverPlayer.func_242111_a(Atum.ATUM, serverPlayer.func_233580_cy_(), serverPlayer.func_70079_am(), true, false);
            world.func_241124_a__(serverPlayer.func_233580_cy_(), 16.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (((Boolean)AtumConfig.ATUM_START.startInAtum.get()).booleanValue() && (livingEntity = event.getEntityLiving()) instanceof ServerPlayerEntity) {
            Optional bedPos;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)livingEntity;
            ServerWorld serverWorld = serverPlayer.func_71121_q();
            BlockPos respawnPos = serverPlayer.func_241140_K_();
            if (respawnPos != null && !(bedPos = PlayerEntity.func_242374_a((ServerWorld)serverWorld, (BlockPos)respawnPos, (float)serverPlayer.func_242109_L(), (boolean)serverPlayer.func_241142_M_(), (boolean)false)).isPresent()) {
                serverPlayer.func_242111_a(Atum.ATUM, serverWorld.func_241135_u_(), serverPlayer.func_70079_am(), true, false);
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && ((Boolean)AtumConfig.GENERAL.allowCreation.get()).booleanValue() && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0 && (world.func_234923_W_() == World.field_234918_g_ || world.func_234923_W_() == Atum.ATUM)) {
            for (ItemEntity entityItem : world.func_217357_a(ItemEntity.class, player.func_174813_aQ().func_72314_b(10.0, 1.0, 10.0))) {
                BlockState state = world.func_180495_p(entityItem.func_233580_cy_());
                if (entityItem.func_92059_d().func_77973_b() != AtumItems.SCARAB || state.func_177230_c() != Blocks.field_150355_j && state != AtumBlocks.PORTAL.func_176223_P() || !AtumBlocks.PORTAL.trySpawnPortal(world, entityItem.func_233580_cy_())) continue;
                entityItem.func_70106_y();
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        BlockState state = event.getPlacedBlock();
        if (event.getEntity() != null && event.getEntity().field_70170_p.func_234923_W_() == Atum.ATUM && (state.func_185904_a() == Material.field_151578_c || state.func_177230_c() == Blocks.field_196658_i || state.func_177230_c() == Blocks.field_150391_bh) && state.func_177230_c() != AtumBlocks.FERTILE_SOIL_TILLED) {
            event.getWorld().func_180501_a(event.getPos(), AtumBlocks.SAND.func_176223_P(), 3);
        }
    }

    @SubscribeEvent
    public static void onArmorClean(PlayerInteractEvent.RightClickBlock event) {
        try {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            PlayerEntity player = event.getPlayer();
            ItemStack stack = player.func_184614_ca();
            LazyOptional lazyTank = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)event.getFace());
            if (stack.func_77973_b() instanceof WandererDyeableArmor && ((WandererDyeableArmor)stack.func_77973_b()).func_200883_f_(stack)) {
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof CauldronBlock) {
                    int level = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
                    if (level > 0) {
                        if (!world.field_72995_K) {
                            ((WandererDyeableArmor)stack.func_77973_b()).func_200884_g(stack);
                            player.func_195066_a(Stats.field_188079_M);
                            ((CauldronBlock)state.func_177230_c()).func_176590_a(world, pos, state, level - 1);
                        }
                        player.func_184185_a(SoundEvents.field_187609_F, 0.16f, 0.66f);
                        event.setUseItem(Event.Result.DENY);
                    }
                } else if (lazyTank.map(f -> f instanceof FluidTank).orElse(false).booleanValue()) {
                    lazyTank.ifPresent(tank -> {
                        FluidTank fluidTank = (FluidTank)tank;
                        if (fluidTank.getFluid().getFluid().func_207185_a((ITag)FluidTags.field_206959_a) && fluidTank.getFluidAmount() >= 250) {
                            if (!world.field_72995_K) {
                                ((WandererDyeableArmor)stack.func_77973_b()).func_200884_g(stack);
                                player.func_195066_a(Stats.field_188079_M);
                                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                            }
                            player.func_184185_a(SoundEvents.field_187609_F, 0.16f, 0.66f);
                            event.setUseItem(Event.Result.ALLOW);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onSeedUse(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        if (player.field_70170_p.func_234923_W_() == Atum.ATUM && player.func_184586_b(event.getHand()).func_77973_b() == Items.field_151014_N && world.func_180495_p(event.getPos()).func_177230_c() instanceof FarmlandBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().equals(DamageSource.field_76369_e) && (event.getEntity() instanceof UndeadBaseEntity || event.getEntity() instanceof StoneBaseEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFishLoot(ItemFishedEvent event) {
        World world = event.getPlayer().field_70170_p;
        FishingBobberEntity bobber = event.getHookEntity();
        PlayerEntity angler = bobber.func_234606_i_();
        if (angler != null) {
            ItemStack heldStack = angler.func_184586_b(angler.func_184600_cs());
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)world);
            builder.func_186469_a((float)EnchantmentHelper.func_191529_b((ItemStack)heldStack) + angler.func_184817_da()).func_216015_a(LootParameters.field_216284_d, (Object)angler).func_216015_a(LootParameters.field_216281_a, (Object)bobber);
            if (world.func_234923_W_() == Atum.ATUM) {
                event.setCanceled(true);
                if (heldStack.func_77973_b() instanceof AtemsBountyItem) {
                    AtumEventListener.catchFish((ServerWorld)world, angler, heldStack, bobber, builder, AtumLootTables.ATEMS_BOUNTY);
                    angler.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(angler.field_70170_p, angler.func_226277_ct_(), angler.func_226278_cu_() + 0.5, angler.func_226281_cx_() + 0.5, world.field_73012_v.nextInt(6) + 1));
                } else {
                    AtumEventListener.catchFish((ServerWorld)world, angler, heldStack, bobber, builder, AtumLootTables.FISHING);
                }
            }
        }
    }

    private static void catchFish(ServerWorld world, PlayerEntity angler, ItemStack heldStack, FishingBobberEntity bobber, LootContext.Builder builder, ResourceLocation lootTable) {
        List loots = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable).func_216113_a(builder.func_216015_a(LootParameters.field_237457_g_, (Object)bobber.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)heldStack).func_216015_a(LootParameters.field_216281_a, (Object)bobber).func_216023_a(world.field_73012_v).func_216022_a(LootParameterSets.field_216262_c));
        for (ItemStack loot : loots) {
            ItemEntity fish = new ItemEntity(bobber.field_70170_p, bobber.func_226277_ct_(), bobber.func_226278_cu_(), bobber.func_226281_cx_(), loot);
            double x = angler.func_226277_ct_() - bobber.func_226277_ct_();
            double y = angler.func_226278_cu_() - bobber.func_226278_cu_();
            double z = angler.func_226281_cx_() - bobber.func_226281_cx_();
            double swush = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            fish.func_213293_j(x * 0.1, y * 0.1 + swush * 0.08, z * 0.1);
            world.func_217376_c((Entity)fish);
        }
    }

    @SubscribeEvent
    public static void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        IWorld world = event.getWorld();
        if ((event.getEntityLiving() instanceof PhantomEntity || event.getEntityLiving().func_200600_R() == EntityType.field_220360_g) && world instanceof ServerWorld && ((ServerWorld)world).func_234923_W_() == Atum.ATUM) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        if (state.func_177230_c() instanceof IUnbreakable && ((Boolean)state.func_177229_b((Property)IUnbreakable.UNBREAKABLE)).booleanValue() && !event.getPlayer().func_184812_l_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent event) {
        if (StackHelper.hasFullArmorSet(event.getEntityLiving(), AtumItems.HALO_OF_RA, AtumItems.BODY_OF_RA, AtumItems.LEGS_OF_RA, AtumItems.FEET_OF_RA) && event.getSource().func_76347_k()) {
            event.setAmount(0.0f);
        }
    }
}

