/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class StackHelper {
    public static CompoundNBT getTag(@Nonnull ItemStack stack) {
        if (!StackHelper.hasTag(stack)) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack.func_77978_p();
    }

    public static boolean hasTag(@Nonnull ItemStack stack) {
        return stack.func_77942_o();
    }

    public static boolean hasKey(@Nonnull ItemStack stack, String string) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(string);
    }

    public static Block getBlockFromName(String name) {
        return StackHelper.getBlockFromName(new ResourceLocation("atum", name));
    }

    public static Block getBlockFromName(ResourceLocation location) {
        return (Block)ForgeRegistries.BLOCKS.getValue(location);
    }

    public static Item getItemFromName(String name) {
        return StackHelper.getItemFromName(new ResourceLocation("atum", name));
    }

    public static Item getItemFromName(ResourceLocation location) {
        return (Item)ForgeRegistries.ITEMS.getValue(location);
    }

    public static void giveItem(PlayerEntity player, Hand hand, @Nonnull ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        } else if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
    }

    public static void dropInventoryItems(World world, BlockPos pos, IInventory inventory) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            StackHelper.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
        }
    }

    public static void spawnItemStack(World world, double x, double y, double z, @Nonnull ItemStack stack) {
        Random random = new Random();
        float xOffset = random.nextFloat() * 0.8f + 0.1f;
        float yOffset = random.nextFloat() * 0.8f + 0.1f;
        float zOffset = random.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            ItemEntity itemEntity = new ItemEntity(world, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, stack.func_77979_a(random.nextInt(21) + 10));
            itemEntity.func_174869_p();
            itemEntity.func_213293_j(random.nextGaussian() * (double)0.05f, random.nextGaussian() * (double)0.05f + (double)0.2f, random.nextGaussian() * (double)0.05f);
            if (world.field_72995_K) continue;
            world.func_217376_c((Entity)itemEntity);
        }
    }

    public static boolean areIngredientsEqualIgnoreSize(@Nonnull Ingredient ingredientA, @Nonnull ItemStack stackB) {
        for (ItemStack stack : ingredientA.func_193365_a()) {
            if (!StackHelper.areStacksEqualIgnoreSize(stack, stackB)) continue;
            return true;
        }
        return false;
    }

    public static boolean areStacksEqualIgnoreSize(@Nonnull ItemStack stackA, @Nonnull ItemStack stackB) {
        if (stackA.func_190926_b() || stackB.func_190926_b()) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        return (stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
    }

    public static Hand getUsedHand(@Nonnull ItemStack stackMainHand, Class<? extends Item> clazz) {
        return clazz.isAssignableFrom(stackMainHand.func_77973_b().getClass()) ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static boolean hasFullArmorSet(LivingEntity livingEntity, Item head, Item chest, Item legs, Item feet) {
        return livingEntity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == head && livingEntity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == chest && livingEntity.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == legs && livingEntity.func_184582_a(EquipmentSlotType.FEET).func_77973_b() == feet;
    }
}

