/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.blocks.lighting.AtumTorchBlock;
import com.teammetallurgy.atum.blocks.lighting.AtumTorchUnlitBlock;
import com.teammetallurgy.atum.blocks.lighting.AtumWallTorch;
import com.teammetallurgy.atum.blocks.lighting.AtumWallTorchUnlitBlock;
import com.teammetallurgy.atum.blocks.wood.AtumWallSignBlock;
import com.teammetallurgy.atum.entity.ai.brain.sensor.AtumSensorTypes;
import com.teammetallurgy.atum.entity.projectile.arrow.CustomArrow;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.init.AtumSounds;
import com.teammetallurgy.atum.items.AtumScaffoldingItem;
import com.teammetallurgy.atum.items.RelicItem;
import com.teammetallurgy.atum.items.tools.ScepterItem;
import com.teammetallurgy.atum.misc.datagenerator.BlockStatesGenerator;
import com.teammetallurgy.atum.misc.datagenerator.RecipeGenerator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.data.BiomeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.SignItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumRegistry {
    private static final List<Item> ITEMS = Lists.newArrayList();
    private static final List<Block> BLOCKS = Lists.newArrayList();
    public static final List<Biome> BIOMES = Lists.newArrayList();
    public static final List<RegistryKey<Biome>> BIOME_KEYS = Lists.newArrayList();
    private static final List<EntityType<?>> ENTITIES = Lists.newArrayList();
    private static final List<SoundEvent> SOUNDS = Lists.newArrayList();
    private static final List<ParticleType<?>> PARTICLES = Lists.newArrayList();
    public static final List<EntityType<? extends CustomArrow>> ARROWS = Lists.newArrayList();
    public static final Supplier<IForgeRegistry<AtumVillagerProfession>> VILLAGER_PROFESSION = AtumVillagerProfession.ATUM_PROFESSION_DEFERRED.makeRegistry("villager_profession", () -> AtumRegistry.makeRegistryNoCreate("villager_profession", AtumVillagerProfession.class));

    public static Item registerItem(@Nonnull Item item, @Nonnull String name) {
        item.setRegistryName(new ResourceLocation("atum", name));
        ITEMS.add(item);
        return item;
    }

    public static RelicItem registerRelic(@Nonnull RelicItem.Type type) {
        Item.Properties nonDirty = new Item.Properties().func_200917_a(16);
        RelicItem dirty = new RelicItem(new Item.Properties().func_200917_a(64));
        AtumRegistry.registerItem(dirty, AtumRegistry.getRelicName(RelicItem.Quality.DIRTY, type));
        AtumRegistry.registerItem(new RelicItem(nonDirty), AtumRegistry.getRelicName(RelicItem.Quality.SILVER, type));
        AtumRegistry.registerItem(new RelicItem(nonDirty), AtumRegistry.getRelicName(RelicItem.Quality.GOLD, type));
        AtumRegistry.registerItem(new RelicItem(nonDirty), AtumRegistry.getRelicName(RelicItem.Quality.SAPPHIRE, type));
        AtumRegistry.registerItem(new RelicItem(nonDirty), AtumRegistry.getRelicName(RelicItem.Quality.RUBY, type));
        AtumRegistry.registerItem(new RelicItem(nonDirty), AtumRegistry.getRelicName(RelicItem.Quality.EMERALD, type));
        AtumRegistry.registerItem(new RelicItem(nonDirty), AtumRegistry.getRelicName(RelicItem.Quality.DIAMOND, type));
        return dirty;
    }

    public static Item registerScepter(God god) {
        ScepterItem scepter = new ScepterItem();
        ScepterItem.SCEPTERS.put(god, scepter);
        return AtumRegistry.registerItem((Item)scepter, "scepter_" + god.getName());
    }

    private static String getRelicName(@Nonnull RelicItem.Quality quality, @Nonnull RelicItem.Type type) {
        RelicItem.RELIC_ENTRIES.add((Object)new RelicItem.RelicEntry(quality, quality.getWeight()));
        return "relic_" + quality.func_176610_l() + "_" + type.func_176610_l();
    }

    public static Block registerTorchWithUnlit(@Nonnull AtumTorchBlock torch, @Nonnull String name) {
        AtumTorchUnlitBlock unlitTorch = new AtumTorchUnlitBlock();
        AtumWallTorch wallTorchLit = new AtumWallTorch(AbstractBlock.Properties.func_200950_a((AbstractBlock)torch).func_222379_b((Block)torch), torch.getParticleType());
        AtumWallTorchUnlitBlock wallTorchUnlit = new AtumWallTorchUnlitBlock((Block)wallTorchLit, AbstractBlock.Properties.func_200950_a((AbstractBlock)unlitTorch).func_222379_b((Block)unlitTorch));
        AtumRegistry.registerBaseBlock((Block)wallTorchLit, "wall_" + name);
        AtumRegistry.registerBaseBlock((Block)wallTorchUnlit, "wall_" + name + "_unlit");
        AtumRegistry.registerBlockWithItem((Block)unlitTorch, (BlockItem)new WallOrFloorItem((Block)unlitTorch, (Block)wallTorchUnlit, new Item.Properties()), name + "_unlit");
        AtumTorchUnlitBlock.UNLIT.put(torch, unlitTorch);
        AtumWallTorchUnlitBlock.UNLIT.put((Block)torch, (Block)wallTorchUnlit);
        AtumTorchUnlitBlock.LIT.put(unlitTorch, torch);
        AtumTorchUnlitBlock.ALL_TORCHES.add(torch);
        AtumTorchUnlitBlock.ALL_TORCHES.add(unlitTorch);
        AtumTorchUnlitBlock.ALL_TORCHES.add(wallTorchLit);
        AtumTorchUnlitBlock.ALL_TORCHES.add(wallTorchUnlit);
        return AtumRegistry.registerBlockWithItem((Block)torch, (BlockItem)new WallOrFloorItem((Block)torch, (Block)wallTorchLit, new Item.Properties().func_200916_a(Atum.GROUP)), name);
    }

    public static Block registerTorch(@Nonnull AtumTorchBlock torch, @Nonnull String name) {
        AtumWallTorch wallTorchLit = new AtumWallTorch(AbstractBlock.Properties.func_200950_a((AbstractBlock)torch).func_222379_b((Block)torch), torch.getParticleType());
        AtumRegistry.registerBaseBlock((Block)wallTorchLit, "wall_" + name);
        AtumTorchUnlitBlock.ALL_TORCHES.add(torch);
        AtumTorchUnlitBlock.ALL_TORCHES.add(wallTorchLit);
        return AtumRegistry.registerBlockWithItem((Block)torch, (BlockItem)new WallOrFloorItem((Block)torch, (Block)wallTorchLit, new Item.Properties().func_200916_a(Atum.GROUP)), name);
    }

    public static Block registerScaffolding(@Nonnull Block scaffolding, @Nonnull String name) {
        return AtumRegistry.registerBlockWithItem(scaffolding, (BlockItem)new AtumScaffoldingItem(scaffolding), name);
    }

    public static Block registerBlock(@Nonnull Block block, @Nonnull String name) {
        return AtumRegistry.registerBlock(block, new Item.Properties(), name);
    }

    public static Block registerBlock(@Nonnull Block block, Supplier<Callable<ItemStackTileEntityRenderer>> ister, @Nullable Item.Properties properties, @Nonnull String name) {
        BlockItem blockItem = new BlockItem(block, properties == null ? new Item.Properties().setISTER(ister) : properties.setISTER(ister).func_200916_a(Atum.GROUP));
        return AtumRegistry.registerBlockWithItem(block, blockItem, name);
    }

    public static Block registerBlock(@Nonnull Block block, @Nullable Item.Properties properties, @Nonnull String name) {
        BlockItem blockItem = new BlockItem(block, properties == null ? new Item.Properties() : properties.func_200916_a(Atum.GROUP));
        return AtumRegistry.registerBlockWithItem(block, blockItem, name);
    }

    public static Block registerBlockWithItem(@Nonnull Block block, BlockItem blockItem, @Nonnull String name) {
        AtumRegistry.registerItem((Item)blockItem, name);
        return AtumRegistry.registerBaseBlock(block, name);
    }

    public static Block registerBaseBlock(@Nonnull Block block, @Nonnull String name) {
        block.setRegistryName(new ResourceLocation("atum", name));
        BLOCKS.add(block);
        return block;
    }

    public static Block registerSign(@Nonnull Block signBlock, @Nonnull WoodType woodType) {
        String typeName = woodType.func_227048_b_().replace("atum_", "");
        AtumWallSignBlock wallSignBlock = new AtumWallSignBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_222379_b(signBlock), woodType);
        SignItem signItem = new SignItem(new Item.Properties().func_200917_a(16).func_200916_a(Atum.GROUP), signBlock, (Block)wallSignBlock);
        AtumWallSignBlock.WALL_SIGN_BLOCKS.put(signBlock, (Block)wallSignBlock);
        AtumRegistry.registerItem((Item)signItem, typeName + "_sign");
        AtumRegistry.registerBaseBlock((Block)wallSignBlock, typeName + "_wall_sign");
        return AtumRegistry.registerBaseBlock(signBlock, typeName + "_sign");
    }

    public static <T extends Entity> EntityType<T> registerMob(String name, int eggPrimary, int eggSecondary, EntityType.Builder<T> builder) {
        EntityType<T> entityType = AtumRegistry.registerEntity(name, builder);
        SpawnEggItem spawnEgg = new SpawnEggItem(entityType, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(Atum.GROUP));
        AtumRegistry.registerItem((Item)spawnEgg, name + "_spawn_egg");
        return entityType;
    }

    public static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder) {
        ResourceLocation location = new ResourceLocation("atum", name);
        EntityType entityType = builder.func_206830_a(location.toString());
        entityType.setRegistryName(location);
        ENTITIES.add(entityType);
        return entityType;
    }

    public static <T extends CustomArrow> EntityType<T> registerArrow(String name, EntityType.IFactory<T> factory, BiFunction<FMLPlayMessages.SpawnEntity, World, T> customClientFactory) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).func_233608_b_(20).setCustomClientFactory(customClientFactory);
        EntityType<T> entityType = AtumRegistry.registerEntity(name, builder);
        ARROWS.add(entityType);
        return entityType;
    }

    public static Biome registerBiome(Biome biome, String name) {
        biome.setRegistryName(new ResourceLocation("atum", name));
        BIOMES.add(biome);
        return biome;
    }

    public static RegistryKey<Biome> registerBiomeKey(String biomeName) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)new ResourceLocation("atum", biomeName));
        BIOME_KEYS.add((RegistryKey<Biome>)biomeKey);
        return biomeKey;
    }

    public static SoundEvent registerSound(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("atum", name);
        SoundEvent sound = new SoundEvent(resourceLocation);
        sound.setRegistryName(resourceLocation);
        SOUNDS.add(sound);
        return sound;
    }

    public static BasicParticleType registerParticle(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("atum", name);
        BasicParticleType particleType = new BasicParticleType(false);
        particleType.setRegistryName(resourceLocation);
        PARTICLES.add((ParticleType<?>)particleType);
        return particleType;
    }

    public static BasicParticleType registerGodFlame(String name, God god) {
        BasicParticleType particleType = AtumRegistry.registerParticle(name);
        AtumTorchBlock.GOD_FLAMES.put(god, (IParticleData)particleType);
        AtumTorchBlock.GODS.put((IParticleData)particleType, god);
        return particleType;
    }

    public static <T extends IForgeRegistryEntry<T>> RegistryBuilder<T> makeRegistryNoCreate(String registryName, Class<T> type) {
        return new RegistryBuilder().setName(new ResourceLocation("atum", registryName)).setType(type).setMaxID(0x3FFFFFF).allowModification();
    }

    public static <T extends IForgeRegistryEntry<T>> IForgeRegistry<T> makeRegistry(String registryName, Class<T> type) {
        return AtumRegistry.makeRegistryNoCreate(registryName, type).create();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        new AtumItems();
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        AtumItems.setItemInfo();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        new AtumBlocks();
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        AtumBlocks.setBlockInfo();
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        for (Biome biome : BIOMES) {
            event.getRegistry().register((IForgeRegistryEntry)biome);
        }
        AtumBiomes.addBiomeTags();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        new AtumEntities();
        for (EntityType<?> entityType : ENTITIES) {
            event.getRegistry().register(entityType);
        }
        AtumEntities.registerSpawnPlacement();
    }

    @SubscribeEvent
    public static void registerSound(RegistryEvent.Register<SoundEvent> event) {
        new AtumSounds();
        for (SoundEvent sound : SOUNDS) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
    }

    @SubscribeEvent
    public static void registerParticle(RegistryEvent.Register<ParticleType<?>> event) {
        new AtumParticles();
        for (ParticleType<?> particleType : PARTICLES) {
            event.getRegistry().register(particleType);
        }
    }

    @SubscribeEvent
    public static void data(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new BlockStatesGenerator(gen, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new RecipeGenerator(gen));
        }
        if (event.includeReports()) {
            gen.func_200390_a((IDataProvider)new BiomeProvider(gen));
        }
    }

    public static void registerDeferredRegistries(IEventBus modBus) {
        AtumVillagerProfession.ATUM_PROFESSION_DEFERRED.register(modBus);
        AtumSensorTypes.SENSOR_TYPE_DEFERRED.register(modBus);
    }
}

