/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.nuit;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.items.artifacts.AmuletItem;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class NuitsVanishingItem
extends AmuletItem
implements IArtifact {
    protected static final Object2BooleanMap<LivingEntity> INVISIBLE = new Object2BooleanOpenHashMap();
    public static final Object2IntMap<LivingEntity> TIMER = new Object2IntOpenHashMap();

    public NuitsVanishingItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    @Override
    public God getGod() {
        return God.NUIT;
    }

    @SubscribeEvent
    public static void onTarget(LivingSetAttackTargetEvent event) {
        if (TIMER.getInt((Object)event.getTarget()) <= 0 && INVISIBLE.getBoolean((Object)event.getTarget()) && event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingAttackEvent event) {
        LivingEntity attacker;
        Entity source = event.getSource().func_76346_g();
        if (source instanceof LivingEntity && INVISIBLE.getBoolean((Object)(attacker = (LivingEntity)source))) {
            NuitsVanishingItem.setNotInvisible(attacker);
            TIMER.putIfAbsent((Object)attacker, 200);
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity livingEntity, @Nonnull ItemStack stack) {
        NuitsVanishingItem.setNotInvisible(livingEntity);
    }

    @Override
    public void curioBreak(@Nonnull ItemStack stack, LivingEntity livingEntity) {
        NuitsVanishingItem.setNotInvisible(livingEntity);
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity livingEntity, @Nonnull ItemStack stack) {
        World world = livingEntity.func_130014_f_();
        if (!TIMER.containsKey((Object)livingEntity)) {
            INVISIBLE.putIfAbsent((Object)livingEntity, true);
            if (!NuitsVanishingItem.isLivingEntityMoving(livingEntity)) {
                INVISIBLE.replace((Object)livingEntity, true);
                if (!world.field_72995_K) {
                    livingEntity.func_82142_c(true);
                }
            } else {
                NuitsVanishingItem.setNotInvisible(livingEntity);
            }
        }
        if (TIMER.containsKey((Object)livingEntity)) {
            int timer = TIMER.getInt((Object)livingEntity);
            if (timer == 0) {
                TIMER.removeInt((Object)livingEntity);
            }
            if (timer > 0) {
                TIMER.replace((Object)livingEntity, timer - 1);
            }
        }
    }

    public static void setNotInvisible(LivingEntity livingEntity) {
        INVISIBLE.replace((Object)livingEntity, false);
        if (!livingEntity.func_130014_f_().field_72995_K && !livingEntity.func_70644_a(Effects.field_76441_p) && livingEntity.func_82150_aj()) {
            livingEntity.func_82142_c(false);
        }
    }

    public static boolean isLivingEntityMoving(LivingEntity livingEntity) {
        return livingEntity.field_70140_Q != livingEntity.field_70141_P || livingEntity.func_213453_ef();
    }
}

