/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.atem;

import com.teammetallurgy.atum.api.AtumMats;
import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.client.model.armor.AtemArmorModel;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.items.artifacts.ArtifactArmor;
import com.teammetallurgy.atum.items.artifacts.atem.AtemsHomecomingItem;
import com.teammetallurgy.atum.misc.StackHelper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtemArmor
extends ArtifactArmor {
    protected static final HashMap<PlayerEntity, Integer> RECALL_TIMER = new HashMap();

    public AtemArmor(EquipmentSlotType slot) {
        super(AtumMats.NEBU_ARMOR, "atem_armor", slot, new Item.Properties().func_208103_a(Rarity.RARE));
        this.setHasRender();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, @Nonnull ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)new AtemArmorModel(armorSlot, this.hasFullSet(entityLiving)));
    }

    @Override
    public God getGod() {
        return God.ATEM;
    }

    @Override
    public Item getHelmet() {
        return AtumItems.EYES_OF_ATEM;
    }

    @Override
    public Item getChestplate() {
        return AtumItems.BODY_OF_ATEM;
    }

    @Override
    public Item getLeggings() {
        return AtumItems.LEGS_OF_ATEM;
    }

    @Override
    public Item getBoots() {
        return AtumItems.FEET_OF_ATEM;
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayerEntity && RECALL_TIMER.containsKey(player)) {
            int recallTimer = RECALL_TIMER.get(player);
            if (recallTimer == 0) {
                RECALL_TIMER.remove(player);
            }
            if (recallTimer > 0) {
                RECALL_TIMER.replace(player, recallTimer - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (event.getAmount() >= player.func_110143_aJ() && StackHelper.hasFullArmorSet(livingEntity, AtumItems.EYES_OF_ATEM, AtumItems.BODY_OF_ATEM, AtumItems.LEGS_OF_ATEM, AtumItems.FEET_OF_ATEM) && !RECALL_TIMER.containsKey(player)) {
                livingEntity.func_70606_j(livingEntity.func_110138_aP());
                AtemsHomecomingItem.recall(livingEntity.field_70170_p, player);
                RECALL_TIMER.put(player, 24000);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && RECALL_TIMER.containsKey(player)) {
            int totalSeconds = RECALL_TIMER.get(player) / 20;
            int minutes = totalSeconds % 3600 / 60;
            int seconds = totalSeconds % 60;
            tooltip.add((ITextComponent)new TranslationTextComponent("atum.recall_cooldown", new Object[]{minutes + ":" + seconds}).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

