/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.api.IFogReductionItem;
import com.teammetallurgy.atum.items.TexturedArmorItem;
import com.teammetallurgy.atum.misc.StackHelper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public abstract class ArtifactArmor
extends TexturedArmorItem
implements IArtifact,
IFogReductionItem {
    private static final AttributeModifier SPEED_BOOST = new AttributeModifier(UUID.fromString("2aa9e06c-cc77-4c0a-b832-58d8aaef1500"), "Artifact boots speed boost", 0.02, AttributeModifier.Operation.ADDITION);

    public ArtifactArmor(IArmorMaterial material, String name, EquipmentSlotType slot, Item.Properties properties) {
        super(material, name, slot, properties.func_200916_a(Atum.GROUP));
    }

    public abstract Item getHelmet();

    public abstract Item getChestplate();

    public abstract Item getLeggings();

    public abstract Item getBoots();

    public boolean hasFullSet(LivingEntity livingEntity) {
        return StackHelper.hasFullArmorSet(livingEntity, this.getHelmet(), this.getChestplate(), this.getLeggings(), this.getBoots());
    }

    public ItemStack[] getArmorSet() {
        return new ItemStack[]{new ItemStack((IItemProvider)this.getHelmet()), new ItemStack((IItemProvider)this.getChestplate()), new ItemStack((IItemProvider)this.getLeggings()), new ItemStack((IItemProvider)this.getBoots())};
    }

    public boolean hasArmorSetPiece(PlayerEntity player, EquipmentSlotType slotType) {
        ItemStack stack = player.func_184582_a(slotType);
        switch (slotType) {
            case HEAD: {
                return stack.func_77973_b() == this.getHelmet();
            }
            case CHEST: {
                return stack.func_77973_b() == this.getChestplate();
            }
            case LEGS: {
                return stack.func_77973_b() == this.getLeggings();
            }
            case FEET: {
                return stack.func_77973_b() == this.getBoots();
            }
        }
        return false;
    }

    private int getArmorPiecesEquipped(PlayerEntity player) {
        int pieces = 0;
        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
            if (slotType.func_188453_a() != EquipmentSlotType.Group.ARMOR || !this.hasArmorSetPiece(player, slotType)) continue;
            ++pieces;
        }
        return pieces;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("atum.armorset." + this.func_185083_B_().func_188450_d()).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new StringTextComponent(""));
            String baseLang = "atum.armorset." + this.getGod().getName() + ".";
            ItemStack[] stacks = this.getArmorSet();
            tooltip.add((ITextComponent)new TranslationTextComponent(baseLang + "name").func_240702_b_(" (" + this.getArmorPiecesEquipped((PlayerEntity)player) + "/" + stacks.length + ") ").func_230530_a_(this.func_200296_o().func_150256_b().func_240718_a_(this.getGod().getColor())).func_230529_a_((ITextComponent)new TranslationTextComponent("atum.tooltip.shift").func_240699_a_(TextFormatting.DARK_GRAY)));
            if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340)) {
                for (int i = 0; i < stacks.length; ++i) {
                    tooltip.add((ITextComponent)stacks[i].func_200301_q().func_230531_f_().func_240699_a_(this.hasArmorSetPiece((PlayerEntity)player, EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)(stacks.length - i - 1))) ? TextFormatting.YELLOW : TextFormatting.DARK_GRAY));
                }
                tooltip.add((ITextComponent)new StringTextComponent(""));
                tooltip.add((ITextComponent)new TranslationTextComponent(baseLang + "desc").func_240699_a_(this.hasFullSet((LivingEntity)player) ? TextFormatting.YELLOW : TextFormatting.DARK_GRAY));
            }
        }
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slotType) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.func_111205_h(slotType));
        if (this.getChestplate() == this && slotType == EquipmentSlotType.CHEST) {
            builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(UUID.fromString("dfdc4a46-06ab-4a7c-b726-1c53e56036d6"), "Armor toughness", 3.0, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        Item legs = livingEntity.func_184582_a(EquipmentSlotType.LEGS).func_77973_b();
        if (legs instanceof ArtifactArmor && legs == ((ArtifactArmor)legs).getLeggings() && livingEntity.func_233570_aj_()) {
            event.setStrength(event.getStrength() * 0.5f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        ModifiableAttributeInstance attribute = player.func_110148_a(Attributes.field_233821_d_);
        if (attribute != null) {
            Item feet = player.func_184582_a(EquipmentSlotType.FEET).func_77973_b();
            if (player.func_70089_S() && feet instanceof ArtifactArmor && feet == ((ArtifactArmor)feet).getBoots()) {
                if (!attribute.func_180374_a(SPEED_BOOST)) {
                    attribute.func_233767_b_(SPEED_BOOST);
                }
            } else if (attribute.func_180374_a(SPEED_BOOST)) {
                attribute.func_111124_b(SPEED_BOOST);
            }
        }
    }

    @Override
    public float getFogReduction(float fogDensity, ItemStack armorItem) {
        return fogDensity / 3.25f;
    }
}

