/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items;

import com.teammetallurgy.atum.Atum;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TexturedArmorItem
extends ArmorItem {
    private final String armorPieceName;
    private boolean hasRender = false;
    private int damageModifier;

    public TexturedArmorItem(IArmorMaterial material, String name, EquipmentSlotType slot) {
        this(material, name, slot, new Item.Properties().func_200916_a(Atum.GROUP));
    }

    public TexturedArmorItem(IArmorMaterial material, String name, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties.func_200916_a(Atum.GROUP));
        this.armorPieceName = name;
    }

    public TexturedArmorItem setDamageModifier(int percentage) {
        this.damageModifier = percentage;
        return this;
    }

    public TexturedArmorItem setHasRender() {
        this.hasRender = true;
        return this;
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        return this.damageModifier > 0 ? super.getMaxDamage(stack) + super.getMaxDamage(stack) * this.damageModifier / 100 : super.getMaxDamage(stack);
    }

    public String getArmorTexture(@Nonnull ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return this.hasRender ? String.format("%s:textures/models/armor/%s.png", "atum", this.armorPieceName) : String.format("%s:textures/models/armor/%s_%d%s.png", "atum", this.armorPieceName, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : "_overlay");
    }
}

