/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.categories;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.atum.api.recipe.recipes.KilnRecipe;
import com.teammetallurgy.atum.client.gui.block.KilnScreen;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.integration.jei.JEIIntegration;
import java.awt.Color;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class KilnRecipeCategory
implements IRecipeCategory<KilnRecipe> {
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableAnimated arrow;

    public KilnRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(KilnScreen.KILN_GUI, 35, 14, 71, 84);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)AtumBlocks.KILN));
        IDrawableStatic staticFlame = guiHelper.createDrawable(KilnScreen.KILN_GUI, 176, 0, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.drawableBuilder(KilnScreen.KILN_GUI, 176, 14, 19, 8).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return JEIIntegration.KILN;
    }

    @Nonnull
    public Class<? extends KilnRecipe> getRecipeClass() {
        return KilnRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent("atum." + this.getUid().func_110623_a()).getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull KilnRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull KilnRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 35, 0);
        guiItemStacks.init(5, false, 35, 48);
        guiItemStacks.set(ingredients);
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex >= 5) {
                boolean showAdvanced;
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
                if (showAdvanced) {
                    tooltip.add(new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{recipe.func_199560_c()}).func_240699_a_(TextFormatting.DARK_GRAY));
                }
            }
        });
    }

    public void draw(KilnRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(matrixStack, 1, 17);
        this.arrow.draw(matrixStack, 43, 38);
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            TranslationTextComponent experienceString = new TranslationTextComponent("gui.jei.category.smelting.experience", new Object[]{Float.valueOf(experience)});
            Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, (ITextComponent)experienceString, -1.0f, (float)(this.background.getHeight() - 13), Color.gray.getRGB());
        }
    }
}

