/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.AtumRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumPointsOfInterest {
    private static final List<PointOfInterestType> POINTS_OF_INTEREST = new ArrayList<PointOfInterestType>();
    private static final Supplier<Set<PointOfInterestType>> WORKSTATIONS = Suppliers.memoize(() -> AtumRegistry.VILLAGER_PROFESSION.get().getValues().stream().map(AtumVillagerProfession::getPointOfInterest).collect(Collectors.toSet()));
    public static final Predicate<PointOfInterestType> ANY_VILLAGER_WORKSTATION = type -> WORKSTATIONS.get().contains(type);
    private static final Set<BlockState> CURIO_DISPLAYS = (Set)ImmutableList.of((Object)AtumBlocks.PALM_CURIO_DISPLAY, (Object)AtumBlocks.DEADWOOD_CURIO_DISPLAY, (Object)AtumBlocks.ACACIA_CURIO_DISPLAY, (Object)AtumBlocks.LIMESTONE_CURIO_DISPLAY, (Object)AtumBlocks.ALABASTER_CURIO_DISPLAY, (Object)AtumBlocks.PORPHYRY_CURIO_DISPLAY, (Object)AtumBlocks.NEBU_CURIO_DISPLAY).stream().flatMap(block -> block.func_176194_O().func_177619_a().stream()).collect(ImmutableSet.toImmutableSet());
    public static final PointOfInterestType PORTAL = AtumPointsOfInterest.register("portal", AtumPointsOfInterest.getAllStates((Block)AtumBlocks.PORTAL), 0, 1);
    public static final PointOfInterestType UNEMPLOYED = AtumPointsOfInterest.register("unemployed", (Set<BlockState>)ImmutableSet.of(), 1, ANY_VILLAGER_WORKSTATION, 1);
    public static final PointOfInterestType CURATOR = AtumPointsOfInterest.register("curator", CURIO_DISPLAYS, 1, 1);
    public static final PointOfInterestType GLASSBLOWER = AtumPointsOfInterest.register("glassblower", AtumPointsOfInterest.getAllStates(AtumBlocks.GLASSBLOWER_FURNACE), 1, 1);

    public static PointOfInterestType register(String name, Set<BlockState> states, int maxFreeTickets, int validRange) {
        ResourceLocation id = new ResourceLocation("atum", name);
        PointOfInterestType pointOfInterestType = PointOfInterestType.func_221052_a((PointOfInterestType)new PointOfInterestType(id.toString(), states, maxFreeTickets, validRange));
        return AtumPointsOfInterest.registerPoi(pointOfInterestType, id);
    }

    public static PointOfInterestType register(String name, Set<BlockState> states, int maxFreeTickets, Predicate<PointOfInterestType> predicate, int validRange) {
        ResourceLocation id = new ResourceLocation("atum", name);
        PointOfInterestType pointOfInterestType = new PointOfInterestType(id.toString(), states, maxFreeTickets, predicate, validRange);
        return AtumPointsOfInterest.registerPoi(pointOfInterestType, id);
    }

    public static PointOfInterestType registerPoi(PointOfInterestType pointOfInterestType, ResourceLocation id) {
        pointOfInterestType.setRegistryName(id);
        POINTS_OF_INTEREST.add(pointOfInterestType);
        return pointOfInterestType;
    }

    private static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.func_176194_O().func_177619_a());
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<PointOfInterestType> event) {
        for (PointOfInterestType pointOfInterest : POINTS_OF_INTEREST) {
            event.getRegistry().register((IForgeRegistryEntry)pointOfInterest);
        }
    }
}

