/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.entity.villager.AtumVillagerData;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.entity.villager.Race;
import com.teammetallurgy.atum.misc.AtumRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumDataSerializer {
    private static final List<DataSerializerEntry> DATA_SERIALIZER_ENTRIES = new ArrayList<DataSerializerEntry>();
    public static final IDataSerializer<AtumVillagerData> VILLAGER_DATA = new IDataSerializer<AtumVillagerData>(){

        public void write(PacketBuffer buf, AtumVillagerData value) {
            buf.func_180714_a(AtumRegistry.VILLAGER_PROFESSION.get().getKey((IForgeRegistryEntry)value.getAtumProfession()).toString());
            buf.func_150787_b(value.func_221132_c());
            buf.func_179249_a((Enum)value.getRace());
        }

        @Nonnull
        public AtumVillagerData read(PacketBuffer buf) {
            return new AtumVillagerData((AtumVillagerProfession)AtumRegistry.VILLAGER_PROFESSION.get().getValue(new ResourceLocation(buf.func_218666_n())), buf.func_150792_a(), (Race)buf.func_179257_a(Race.class));
        }

        @Nonnull
        public AtumVillagerData copyValue(@Nonnull AtumVillagerData value) {
            return value;
        }
    };
    private static final DataSerializerEntry VILLAGER_DATA_ENTRY = AtumDataSerializer.register("villager_data", new DataSerializerEntry(VILLAGER_DATA));

    public static DataSerializerEntry register(String name, DataSerializerEntry dataSerializerEntry) {
        ResourceLocation id = new ResourceLocation("atum", name);
        dataSerializerEntry.setRegistryName(id);
        DATA_SERIALIZER_ENTRIES.add(dataSerializerEntry);
        return dataSerializerEntry;
    }

    @SubscribeEvent
    public static void registerDataSerializers(RegistryEvent.Register<DataSerializerEntry> event) {
        for (DataSerializerEntry dataSerializerEntry : DATA_SERIALIZER_ENTRIES) {
            event.getRegistry().register((IForgeRegistryEntry)dataSerializerEntry);
        }
    }
}

