/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.teammetallurgy.atum.api.AtumAPI;
import com.teammetallurgy.atum.entity.ITexture;
import com.teammetallurgy.atum.entity.ai.brain.sensor.AtumSensorTypes;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumVillagerTasks;
import com.teammetallurgy.atum.entity.villager.AtumVillagerData;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.entity.villager.AtumVillagerTrades;
import com.teammetallurgy.atum.entity.villager.Race;
import com.teammetallurgy.atum.init.AtumDataSerializer;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumPointsOfInterest;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import org.apache.logging.log4j.Logger;

public class AtumVillagerEntity
extends VillagerEntity
implements ITexture {
    private static final DataParameter<AtumVillagerData> ATUM_VILLAGER_DATA = EntityDataManager.func_187226_a(AtumVillagerEntity.class, AtumDataSerializer.VILLAGER_DATA);
    public static final Map<Item, Integer> FOOD_VALUES = ImmutableMap.of((Object)AtumItems.EMMER_BREAD, (Object)4, (Object)Items.field_151025_P, (Object)4, (Object)Items.field_151174_bG, (Object)1, (Object)Items.field_151172_bF, (Object)1, (Object)Items.field_185164_cV, (Object)1);
    private static final Set<Item> ALLOWED_INVENTORY_ITEMS = ImmutableSet.of((Object)AtumItems.EMMER_BREAD, (Object)AtumItems.EMMER_EAR, (Object)AtumItems.EMMER_SEEDS, (Object)Items.field_151025_P, (Object)Items.field_151174_bG, (Object)Items.field_151172_bF, (Object[])new Item[]{Items.field_151015_O, Items.field_151014_N, Items.field_185164_cV, Items.field_185163_cU});
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(AtumVillagerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String texturePath;
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleType.field_234101_d_, (Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220947_h, (Object)MemoryModuleType.field_220948_i, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_234102_l_, (Object)MemoryModuleType.field_234076_J_, (Object)MemoryModuleType.field_220950_k, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220951_l, MemoryModuleType.field_220952_m, MemoryModuleType.field_220953_n, MemoryModuleType.field_220954_o, MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220944_e, MemoryModuleType.field_220961_v, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_, MemoryModuleType.field_223544_z, MemoryModuleType.field_242309_E, MemoryModuleType.field_234080_N_, MemoryModuleType.field_234081_O_, MemoryModuleType.field_242311_P});
    private static final ImmutableList<SensorType<? extends Sensor<? super VillagerEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_234129_b_, (Object)SensorType.field_221001_e, (Object)SensorType.field_221002_f, (Object)SensorType.field_221003_g, (Object)SensorType.field_221004_h, (Object)((SensorType)AtumSensorTypes.SECONDARY_POIS.get()), (Object)SensorType.field_242317_j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<AtumVillagerEntity, PointOfInterestType>> JOB_SITE_PREDICATE_MAP = ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (villager, poiType) -> poiType == PointOfInterestType.field_221069_q, (Object)MemoryModuleType.field_220942_c, (villager, poiType) -> villager.getAtumVillagerData().getAtumProfession().getPointOfInterest() == poiType, (Object)MemoryModuleType.field_234101_d_, (villager, poiType) -> AtumPointsOfInterest.ANY_VILLAGER_WORKSTATION.test((PointOfInterestType)poiType), (Object)MemoryModuleType.field_220943_d, (villager, poiType) -> poiType == PointOfInterestType.field_221070_r);

    public AtumVillagerEntity(EntityType<? extends AtumVillagerEntity> type, World world) {
        super(type, world, VillagerType.field_221173_a);
        this.setAtumVillagerData(this.getAtumVillagerData().withProfession((AtumVillagerProfession)AtumVillagerProfession.NONE.get()));
    }

    public boolean isFemale() {
        return this.func_200600_R() == AtumEntities.VILLAGER_FEMALE;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATUM_VILLAGER_DATA, (Object)new AtumVillagerData((AtumVillagerProfession)AtumVillagerProfession.NONE.get(), 1, Race.HUMAN));
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    @Nonnull
    protected Brain<?> func_213364_a(@Nonnull Dynamic<?> dynamic) {
        Brain brain = this.func_230289_cH_().func_233748_a_(dynamic);
        this.initBrain((Brain<VillagerEntity>)brain);
        return brain;
    }

    public void func_213770_a(@Nonnull ServerWorld serverWorld) {
        Brain brain = this.func_213375_cj();
        brain.func_218227_b(serverWorld, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain((Brain<VillagerEntity>)this.func_213375_cj());
    }

    @Nonnull
    protected Brain.BrainCodec<VillagerEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_TYPES, SENSOR_TYPES);
    }

    private void initBrain(Brain<VillagerEntity> brain) {
        AtumVillagerProfession profession = this.getAtumVillagerData().getAtumProfession();
        EntityType entityType = this.func_200600_R();
        if (this.func_70631_g_()) {
            brain.func_218203_a(Schedule.field_221385_c);
            brain.func_218208_a(Activity.field_221368_d, AtumVillagerTasks.play((EntityType<? extends AtumVillagerEntity>)entityType, 0.5f));
        } else {
            brain.func_218203_a(Schedule.field_221386_d);
            brain.func_233700_a_(Activity.field_221367_c, AtumVillagerTasks.work((EntityType<? extends AtumVillagerEntity>)entityType, profession, 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        }
        brain.func_218208_a(Activity.field_221365_a, AtumVillagerTasks.core((EntityType<? extends AtumVillagerEntity>)entityType, profession, 0.5f));
        brain.func_233700_a_(Activity.field_221370_f, AtumVillagerTasks.meet((EntityType<? extends AtumVillagerEntity>)entityType, 0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        brain.func_218208_a(Activity.field_221369_e, AtumVillagerTasks.rest((EntityType<? extends AtumVillagerEntity>)entityType, 0.5f));
        brain.func_218208_a(Activity.field_221366_b, AtumVillagerTasks.idle((EntityType<? extends AtumVillagerEntity>)entityType, 0.5f));
        brain.func_218208_a(Activity.field_221371_g, AtumVillagerTasks.panic((EntityType<? extends AtumVillagerEntity>)entityType, 0.5f));
        brain.func_218208_a(Activity.field_221374_j, AtumVillagerTasks.hide((EntityType<? extends AtumVillagerEntity>)entityType, 0.5f));
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    public void func_213742_a(@Nonnull MemoryModuleType<GlobalPos> moduleType) {
        if (this.field_70170_p instanceof ServerWorld) {
            MinecraftServer server = ((ServerWorld)this.field_70170_p).func_73046_m();
            this.field_213378_br.func_218207_c(moduleType).ifPresent(jobSitePos -> {
                ServerWorld serverWorld = server.func_71218_a(jobSitePos.func_239646_a_());
                if (serverWorld != null) {
                    PointOfInterestManager posManger = serverWorld.func_217443_B();
                    Optional optional = posManger.func_219148_c(jobSitePos.func_218180_b());
                    BiPredicate<AtumVillagerEntity, PointOfInterestType> p = JOB_SITE_PREDICATE_MAP.get(moduleType);
                    if (optional.isPresent() && p.test(this, (PointOfInterestType)optional.get())) {
                        posManger.func_219142_b(jobSitePos.func_218180_b());
                        DebugPacketSender.func_218801_c((ServerWorld)serverWorld, (BlockPos)jobSitePos.func_218180_b());
                    }
                }
            });
        }
    }

    protected float func_213348_b(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return this.func_70631_g_() ? 0.65f : 1.55f;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getAtumVillagerData().getAtumProfession() == AtumVillagerProfession.NONE.get() && this.func_213716_dX()) {
            this.resetAtumCustomer();
        }
    }

    protected void func_213750_eg() {
    }

    protected void resetAtumCustomer() {
        this.func_70932_a_(null);
        this.resetAllSpecialPrices();
    }

    private void resetAllSpecialPrices() {
        for (MerchantOffer offer : this.func_213706_dY()) {
            offer.func_222220_k();
        }
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        boolean shouldReset = this.func_70931_l_() != null && player == null;
        super.func_70932_a_(player);
        if (shouldReset) {
            this.resetAtumCustomer();
        }
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        this.resetAtumCustomer();
    }

    @Nullable
    public Entity changeDimension(@Nonnull ServerWorld server, @Nonnull ITeleporter teleporter) {
        this.resetAtumCustomer();
        return super.changeDimension(server, teleporter);
    }

    @Deprecated
    public VillagerData func_213700_eh() {
        return this.getAtumVillagerData();
    }

    public AtumVillagerData getAtumVillagerData() {
        return (AtumVillagerData)((Object)this.field_70180_af.func_187225_a(ATUM_VILLAGER_DATA));
    }

    public void func_213753_a(@Nonnull VillagerData data) {
        if (data instanceof AtumVillagerData) {
            this.setAtumVillagerData((AtumVillagerData)data);
        }
    }

    public void setAtumVillagerData(@Nonnull AtumVillagerData data) {
        this.field_70180_af.func_187227_b(ATUM_VILLAGER_DATA, (Object)data);
    }

    public VillagerEntity func_241840_a(@Nonnull ServerWorld serverWorld, @Nonnull AgeableEntity partner) {
        AtumVillagerEntity atumVillagerEntity = new AtumVillagerEntity(AtumEntities.VILLAGER_MALE, (World)serverWorld);
        if (serverWorld.field_73012_v.nextDouble() >= 0.5) {
            atumVillagerEntity = new AtumVillagerEntity(AtumEntities.VILLAGER_FEMALE, (World)serverWorld);
        }
        if (partner instanceof AtumVillagerEntity) {
            Race childRace = serverWorld.field_73012_v.nextDouble() <= 0.5 ? ((AtumVillagerEntity)partner).getAtumVillagerData().getRace() : this.getAtumVillagerData().getRace();
            atumVillagerEntity.setAtumVillagerData(atumVillagerEntity.getAtumVillagerData().withRace(childRace));
        }
        atumVillagerEntity.func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(atumVillagerEntity.func_233580_cy_()), SpawnReason.BREEDING, null, null);
        return atumVillagerEntity;
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        Race race = Race.getRandomRaceWeighted();
        this.setAtumVillagerData(this.getAtumVillagerData().withRace(race));
        this.setRandomVariant(race);
        if (reason == SpawnReason.BREEDING) {
            this.setAtumVillagerData(this.getAtumVillagerData().withProfession((AtumVillagerProfession)AtumVillagerProfession.NONE.get()));
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getVariant() == -1) {
            Race race = this.getAtumVillagerData().getRace();
            this.setRandomVariant(race);
        }
    }

    public void setRandomVariant(Race race) {
        int variant = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)race.getVariantAmount());
        this.setVariant(variant);
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        AtumVillagerData villagerData = this.getAtumVillagerData();
        ResourceLocation profName = villagerData.getAtumProfession().getRegistryName();
        return new TranslationTextComponent(this.func_200600_R().func_210760_d() + '.' + villagerData.getRace().getName() + "." + profName.func_110623_a());
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            AtumVillagerData atumVillagerData = this.getAtumVillagerData();
            String gender = this.isFemale() ? "female" : "male";
            this.texturePath = new ResourceLocation("atum", "textures/entity/villager/" + atumVillagerData.getRace().getName() + "/" + gender + "_" + this.getVariant()) + ".png";
        }
        return this.texturePath;
    }

    public void func_213767_ej() {
        SoundEvent soundEvent = this.getAtumVillagerData().getAtumProfession().getSound();
        if (soundEvent != null) {
            this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        AtumVillagerData.CODEC.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.getAtumVillagerData()).resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(data -> compound.func_218657_a("AtumVillagerData", data));
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("AtumVillagerData", 10)) {
            DataResult dataresult = AtumVillagerData.CODEC.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("AtumVillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(this::setAtumVillagerData);
        }
        this.setVariant(compound.func_74762_e("Variant"));
    }

    protected void func_175554_cu() {
        this.setAtumVillagerData(this.getAtumVillagerData().withLevel(this.getAtumVillagerData().func_221132_c() + 1));
        this.func_213712_ef();
    }

    private boolean isHungry() {
        return this.field_213781_bL < 12;
    }

    protected void func_213765_en() {
        if (this.isHungry() && this.func_213751_ew() != 0) {
            for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
                int count;
                Integer integer;
                ItemStack stack = this.func_213715_ed().func_70301_a(i);
                if (stack.func_190926_b() || (integer = FOOD_VALUES.get(stack.func_77973_b())) == null) continue;
                for (int k = count = stack.func_190916_E(); k > 0; --k) {
                    this.field_213781_bL = (byte)(this.field_213781_bL + integer);
                    this.func_213715_ed().func_70298_a(i, 1);
                    if (this.isHungry()) continue;
                    return;
                }
            }
        }
    }

    protected int func_213751_ew() {
        Inventory inventory = this.func_213715_ed();
        return FOOD_VALUES.entrySet().stream().mapToInt(foodValueEntry -> inventory.func_213901_a((Item)foodValueEntry.getKey()) * (Integer)foodValueEntry.getValue()).sum();
    }

    public boolean func_230293_i_(ItemStack stack) {
        Item item = stack.func_77973_b();
        AtumVillagerProfession profession = this.getAtumVillagerData().getAtumProfession();
        return ALLOWED_INVENTORY_ITEMS.contains(item) || (profession.getSpecificItems().contains((Object)item) || profession == AtumVillagerProfession.CURATOR.get() && (AtumVillagerTasks.canCuratorPickup(this, stack) || ALLOWED_INVENTORY_ITEMS.contains(item))) && this.func_213715_ed().func_233541_b_(stack);
    }

    public boolean func_175556_cs() {
        return super.func_175556_cs() || this.func_213715_ed().func_213902_a((Set)ImmutableSet.of((Object)AtumItems.EMMER_SEEDS, (Object)AtumItems.FLAX_SEEDS));
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] trades;
        AtumVillagerData data = this.getAtumVillagerData();
        Int2ObjectMap<VillagerTrades.ITrade[]> map = AtumVillagerTrades.VILLAGER_DEFAULT_TRADES.get((Object)data.getAtumProfession());
        if (map != null && !map.isEmpty() && (trades = (VillagerTrades.ITrade[])map.get(data.func_221132_c())) != null) {
            MerchantOffers offers = this.func_213706_dY();
            this.func_213717_a(offers, trades, 2);
        }
    }

    protected void func_175445_a(@Nonnull ItemEntity itemEntity) {
        if (this.getAtumVillagerData().getAtumProfession() == AtumVillagerProfession.CURATOR.get()) {
            this.func_233630_a_(itemEntity);
            AtumVillagerTasks.putInHand(this, itemEntity);
        } else {
            super.func_175445_a(itemEntity);
        }
    }

    public void setOffHand(@Nonnull ItemStack stack) {
        if (stack.func_77973_b().func_206844_a(AtumAPI.Tags.RELIC_NON_DIRTY)) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, stack);
            this.func_233663_d_(EquipmentSlotType.OFFHAND);
        } else {
            this.func_233657_b_(EquipmentSlotType.OFFHAND, stack);
        }
    }
}

