/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.projectile;

import com.teammetallurgy.atum.entity.animal.CamelEntity;
import com.teammetallurgy.atum.init.AtumEntities;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class CamelSpitEntity
extends LlamaSpitEntity {
    public CamelSpitEntity(FMLPlayMessages.SpawnEntity spawnPacket, World world) {
        this(AtumEntities.CAMEL_SPIT, world);
    }

    public CamelSpitEntity(EntityType<? extends CamelSpitEntity> entityType, World world) {
        super(entityType, world);
    }

    public CamelSpitEntity(World world, CamelEntity camel) {
        this(AtumEntities.CAMEL_SPIT, world);
        super.func_212361_a((Entity)camel);
        this.func_70107_b(camel.func_226277_ct_() - (double)(camel.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(camel.field_70761_aq * ((float)Math.PI / 180))), camel.func_226278_cu_() + (double)camel.func_70047_e() - (double)0.1f, camel.func_226281_cx_() + (double)(camel.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(camel.field_70761_aq * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public CamelSpitEntity(World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this(AtumEntities.CAMEL_SPIT, world);
        this.func_70107_b(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            world.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, xSpeed * d0, ySpeed, zSpeed * d0);
        }
        this.func_213293_j(xSpeed, ySpeed, zSpeed);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d motion = this.func_213322_ci();
        RayTraceResult raytrace = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((CamelSpitEntity)this).func_230298_a_(arg_0));
        if (raytrace != null && raytrace.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytrace)) {
            this.func_70227_a(raytrace);
        }
        double d0 = this.func_226277_ct_() + motion.field_72450_a;
        double d1 = this.func_226278_cu_() + motion.field_72448_b;
        double d2 = this.func_226281_cx_() + motion.field_72449_c;
        this.func_234617_x_();
        if (this.field_70170_p.func_234853_a_(this.func_174813_aQ()).noneMatch(AbstractBlock.AbstractBlockState::func_196958_f)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(motion.func_186678_a((double)0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            }
            this.func_70107_b(d0, d1, d2);
        }
    }

    protected void func_213868_a(@Nonnull EntityRayTraceResult rayTraceResult) {
        super.func_213868_a(rayTraceResult);
        Entity entity = this.func_234616_v_();
        if (entity instanceof LivingEntity) {
            rayTraceResult.func_216348_a().func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)((LivingEntity)entity)).func_76349_b(), 1.0f);
        }
    }

    protected void func_230299_a_(@Nonnull BlockRayTraceResult rayTraceResult) {
        super.func_230299_a_(rayTraceResult);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }
}

