/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.atum.entity.villager.AtumVillagerData;
import com.teammetallurgy.atum.entity.villager.AtumVillagerEntity;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.misc.AtumRegistry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class VillagerLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final Int2ObjectMap<ResourceLocation> TIERS = (Int2ObjectMap)Util.func_200696_a((Object)new Int2ObjectOpenHashMap(), m -> {
        m.put(1, (Object)new ResourceLocation("atum", "gold"));
        m.put(2, (Object)new ResourceLocation("atum", "sapphire"));
        m.put(3, (Object)new ResourceLocation("atum", "ruby"));
        m.put(4, (Object)new ResourceLocation("atum", "emerald"));
        m.put(5, (Object)new ResourceLocation("atum", "diamond"));
    });
    private final String path;

    public VillagerLayer(IEntityRenderer<T, M> entityRenderer, String path) {
        super(entityRenderer);
        this.path = path;
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight, T villager, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!villager.func_82150_aj() && villager instanceof AtumVillagerEntity) {
            AtumVillagerData data = ((AtumVillagerEntity)villager).getAtumVillagerData();
            AtumVillagerProfession profession = data.getAtumProfession();
            EntityModel m = this.func_215332_c();
            if (profession != AtumVillagerProfession.NONE.get() && !villager.func_70631_g_()) {
                ResourceLocation professionLocation = this.getLocation("profession", ((AtumVillagerEntity)villager).isFemale() ? "female" : "male", AtumRegistry.VILLAGER_PROFESSION.get().getKey((IForgeRegistryEntry)profession));
                VillagerLayer.func_229141_a_((EntityModel)m, (ResourceLocation)professionLocation, (MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)packedLight, villager, (float)1.0f, (float)1.0f, (float)1.0f);
                if (profession != AtumVillagerProfession.NITWIT.get()) {
                    ResourceLocation professionLevelLocation = this.getLocation("profession_level", null, (ResourceLocation)TIERS.get(MathHelper.func_76125_a((int)data.func_221132_c(), (int)1, (int)TIERS.size())));
                    VillagerLayer.func_229141_a_((EntityModel)m, (ResourceLocation)professionLevelLocation, (MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (int)packedLight, villager, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    private ResourceLocation getLocation(String type, @Nullable String gender, ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "textures/entity/" + this.path + "/" + type + "/" + (gender != null ? gender + "/" : "") + location.func_110623_a() + ".png");
    }
}

