/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.client.model.entity.CamelModel;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class CamelArmorLayer
extends LayerRenderer<CamelEntity, CamelModel<CamelEntity>> {
    private static final Map<CamelEntity.ArmorType, ResourceLocation> CACHE = (Map)Util.func_200696_a((Object)Maps.newEnumMap(CamelEntity.ArmorType.class), m -> {
        m.put(CamelEntity.ArmorType.NONE, null);
        m.put(CamelEntity.ArmorType.IRON, new ResourceLocation("atum", "textures/entity/armor/camel_armor_iron.png"));
        m.put(CamelEntity.ArmorType.GOLD, new ResourceLocation("atum", "textures/entity/armor/camel_armor_gold.png"));
        m.put(CamelEntity.ArmorType.DIAMOND, new ResourceLocation("atum", "textures/entity/armor/camel_armor_diamond.png"));
    });
    private final CamelModel<CamelEntity> model = new CamelModel(0.1f);

    public CamelArmorLayer(IEntityRenderer<CamelEntity, CamelModel<CamelEntity>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight, CamelEntity camel, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack armor = camel.getArmor();
        if (!armor.func_190926_b()) {
            CamelEntity.ArmorType armorType = CamelEntity.ArmorType.getByItemStack(armor);
            ((CamelModel)this.func_215332_c()).func_217111_a(this.model);
            this.model.func_212843_a_((Entity)camel, limbSwing, limbSwingAmount, partialTicks);
            this.model.setRotationAngles(camel, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ResourceLocation resourceLocation = CACHE.get((Object)armorType);
            if (resourceLocation != null) {
                IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)resourceLocation));
                this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

