/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.TintedAgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DesertWolfModel<T extends DesertWolfEntity>
extends TintedAgeableModel<T> {
    private final ModelRenderer head = new ModelRenderer((Model)this, 0, 0);
    private final ModelRenderer body;
    private final ModelRenderer wolfLeg1;
    private final ModelRenderer wolfLeg2;
    private final ModelRenderer wolfLeg3;
    private final ModelRenderer wolfLeg4;
    private final ModelRenderer tail;
    private final ModelRenderer mane;

    public DesertWolfModel(float size) {
        this.head.func_228301_a_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, size);
        this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
        this.body = new ModelRenderer((Model)this, 18, 14);
        this.body.func_228301_a_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, size);
        this.body.func_78793_a(0.0f, 14.0f, 2.0f);
        this.mane = new ModelRenderer((Model)this, 21, 0);
        this.mane.func_228301_a_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, size);
        this.mane.func_78793_a(-1.0f, 14.0f, 2.0f);
        this.wolfLeg1 = new ModelRenderer((Model)this, 0, 18);
        this.wolfLeg1.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, size);
        this.wolfLeg1.func_78793_a(-2.5f, 16.0f, 7.0f);
        this.wolfLeg2 = new ModelRenderer((Model)this, 0, 18);
        this.wolfLeg2.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, size);
        this.wolfLeg2.func_78793_a(0.5f, 16.0f, 7.0f);
        this.wolfLeg3 = new ModelRenderer((Model)this, 0, 18);
        this.wolfLeg3.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, size);
        this.wolfLeg3.func_78793_a(-2.5f, 16.0f, -4.0f);
        this.wolfLeg4 = new ModelRenderer((Model)this, 0, 18);
        this.wolfLeg4.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, size);
        this.wolfLeg4.func_78793_a(0.5f, 16.0f, -4.0f);
        this.tail = new ModelRenderer((Model)this, 9, 18);
        this.tail.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, size);
        this.tail.func_78793_a(-1.0f, 12.0f, 8.0f);
        this.head.func_78784_a(16, 14).func_228301_a_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, size);
        this.head.func_78784_a(16, 14).func_228301_a_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, size);
        this.head.func_78784_a(0, 10).func_228301_a_(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f, size);
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.wolfLeg1, (Object)this.wolfLeg2, (Object)this.wolfLeg3, (Object)this.wolfLeg4, (Object)this.tail, (Object)this.mane);
    }

    public void setLivingAnimations(T desertWolf, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (((DesertWolfEntity)((Object)desertWolf)).func_233678_J__()) {
            this.tail.field_78796_g = 0.0f;
        } else {
            float tailAmount = desertWolf.func_184207_aI() ? 0.5f : 1.4f;
            this.tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * tailAmount * limbSwingAmount;
        }
        if (desertWolf.func_233684_eK_()) {
            this.mane.func_78793_a(-1.0f, 16.0f, -3.0f);
            this.mane.field_78795_f = 1.2566371f;
            this.mane.field_78796_g = 0.0f;
            this.body.func_78793_a(0.0f, 18.0f, 0.0f);
            this.body.field_78795_f = 0.7853982f;
            this.tail.func_78793_a(-1.0f, 21.0f, 6.0f);
            this.wolfLeg1.func_78793_a(-2.5f, 22.0f, 2.0f);
            this.wolfLeg1.field_78795_f = 4.712389f;
            this.wolfLeg2.func_78793_a(0.5f, 22.0f, 2.0f);
            this.wolfLeg2.field_78795_f = 4.712389f;
            this.wolfLeg3.field_78795_f = 5.811947f;
            this.wolfLeg3.func_78793_a(-2.49f, 17.0f, -4.0f);
            this.wolfLeg4.field_78795_f = 5.811947f;
            this.wolfLeg4.func_78793_a(0.51f, 17.0f, -4.0f);
        } else {
            this.body.func_78793_a(0.0f, 14.0f, 2.0f);
            this.body.field_78795_f = 1.5707964f;
            this.mane.func_78793_a(-1.0f, 14.0f, -3.0f);
            this.mane.field_78795_f = this.body.field_78795_f;
            this.tail.func_78793_a(-1.0f, 12.0f, 8.0f);
            this.wolfLeg1.func_78793_a(-2.5f, 16.0f, 7.0f);
            this.wolfLeg2.func_78793_a(0.5f, 16.0f, 7.0f);
            this.wolfLeg3.func_78793_a(-2.5f, 16.0f, -4.0f);
            this.wolfLeg4.func_78793_a(0.5f, 16.0f, -4.0f);
            this.wolfLeg1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.wolfLeg2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.wolfLeg3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.wolfLeg4.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        if (desertWolf.func_184207_aI()) {
            this.head.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 0.15f * limbSwingAmount;
        }
        this.head.field_78808_h = ((DesertWolfEntity)((Object)desertWolf)).getInterestedAngle(partialTickTime) + ((DesertWolfEntity)((Object)desertWolf)).getShakeAngle(partialTickTime, 0.0f);
        this.mane.field_78808_h = ((DesertWolfEntity)((Object)desertWolf)).getShakeAngle(partialTickTime, -0.08f);
        this.body.field_78808_h = ((DesertWolfEntity)((Object)desertWolf)).getShakeAngle(partialTickTime, -0.16f);
        this.tail.field_78808_h = ((DesertWolfEntity)((Object)desertWolf)).getShakeAngle(partialTickTime, -0.2f);
    }

    public void setRotationAngles(T desertWolf, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!desertWolf.func_184207_aI()) {
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        }
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.tail.field_78795_f = ageInTicks;
    }
}

