/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.items.artifacts.ArtifactArmor;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.SandstormHandler;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum", value={Dist.CLIENT})
public class SandstormRendering {
    private static final ResourceLocation SAND_BLUR_TEXTURE = new ResourceLocation("atum", "textures/hud/sandstormwip.png");
    private static float intensity = 1.0f;

    @SubscribeEvent
    public static void renderlast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p.func_234923_W_() == Atum.ATUM) {
            if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                SandstormRendering.renderSand(event.getPartialTicks(), 1, 2, 3, 4, 5, 6);
            } else {
                SandstormRendering.renderSand(event.getPartialTicks(), 1, 2, 3, 4, 5, 6);
            }
        }
    }

    private static void renderSand(float partialTicks, int ... layers) {
        float baseDarkness = (float)((Integer)AtumConfig.SANDSTORM.sandDarkness.get()).intValue() / 100.0f;
        float baseAlpha = (float)((Integer)AtumConfig.SANDSTORM.sandAlpha.get()).intValue() / 100.0f;
        float eyesOfAtumAlpha = (float)((Integer)AtumConfig.SANDSTORM.sandEyesAlpha.get()).intValue() / 100.0f;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (mc.field_71441_e != null && mc.field_71441_e.func_234923_W_() == Atum.ATUM) {
            ClientWorld world = mc.field_71441_e;
            float stormStrength = SandstormHandler.INSTANCE.stormStrength;
            if (stormStrength < 1.0E-4f) {
                return;
            }
            float light = SandstormRendering.getSunBrightness((World)world, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)mc.func_228018_at_().func_198107_o(), (double)mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.disableAlphaTest();
            mc.func_110434_K().func_110577_a(SAND_BLUR_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            BlockPos playerPos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            boolean sky = player.field_70170_p.func_175710_j(playerPos);
            Optional biomeKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)player.field_70170_p.func_226691_t_(playerPos));
            if (!sky || playerPos.func_177956_o() < 50 || biomeKey.isPresent() && biomeKey.get() == AtumBiomes.OASIS) {
                intensity -= 0.006f * partialTicks;
                intensity = Math.max(0.0f, intensity);
            } else {
                intensity += 0.01f * partialTicks;
                intensity = Math.min(stormStrength, intensity);
            }
            for (int i : layers) {
                float scale = 0.2f / (float)i;
                float alpha = (float)Math.pow(intensity - baseAlpha, i) * intensity;
                ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
                if (helmet.func_77973_b() instanceof ArtifactArmor) {
                    alpha *= eyesOfAtumAlpha;
                }
                RenderSystem.color4f((float)(baseDarkness * light), (float)(baseDarkness * light), (float)(baseDarkness * light), (float)alpha);
                double scaleX = (double)(0.01f * (float)mc.func_228018_at_().func_198087_p() * scale) * mc.func_228018_at_().func_198100_s();
                double scaleY = (double)(0.01f * (float)mc.func_228018_at_().func_198107_o() * scale) * mc.func_228018_at_().func_198100_s();
                float speed = 500.0f - (float)(i * 15);
                float movement = (float)(-(System.currentTimeMillis() % (long)((int)speed))) / speed;
                float yaw = 0.25f * (player.field_70177_z % 360.0f / 360.0f) / scale;
                float pitch = 0.5f * (player.field_70125_A % 360.0f / 360.0f) / scale;
                bufferbuilder.func_225582_a_(0.0, (double)mc.func_228018_at_().func_198087_p(), 90.0).func_225583_a_(movement + yaw, (float)(1.0 / scaleY + (double)pitch)).func_181675_d();
                bufferbuilder.func_225582_a_((double)mc.func_228018_at_().func_198107_o(), (double)mc.func_228018_at_().func_198087_p(), 90.0).func_225583_a_((float)(1.0 / scaleX + (double)movement + (double)yaw), (float)(1.0 / scaleY + (double)pitch)).func_181675_d();
                bufferbuilder.func_225582_a_((double)mc.func_228018_at_().func_198107_o(), 0.0, 90.0).func_225583_a_((float)(1.0 / scaleX + (double)movement + (double)yaw), 0.0f + pitch).func_181675_d();
                bufferbuilder.func_225582_a_(0.0, 0.0, 90.0).func_225583_a_(movement + yaw, 0.0f + pitch).func_181675_d();
            }
            tessellator.func_78381_a();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
        }
    }

    public static float getSunBrightness(World world, float partialTicks) {
        float celestialAngle = world.func_72929_e(partialTicks);
        float f1 = 1.0f - celestialAngle * 2.0f + 0.2f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }
}

