/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.IFogReductionItem;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.items.artifacts.nuit.NuitsVanishingItem;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.SandstormHandler;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="atum", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation MUMMY_BLUR_TEXTURE = new ResourceLocation("atum", "textures/hud/mummyblur.png");

    @SubscribeEvent
    public static void renderFog(EntityViewRenderEvent.RenderFogEvent event) {
        float sandstormFog = ((Integer)AtumConfig.SANDSTORM.sandstormFog.get()).intValue();
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer == null) {
            return;
        }
        Entity entity = event.getInfo().func_216773_g();
        World world = entity.field_70170_p;
        if (world.func_234923_W_() == Atum.ATUM && ((Boolean)AtumConfig.GENERAL.fogEnabled.get()).booleanValue()) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            float fogDensity = 0.05f;
            if (entity instanceof PlayerEntity) {
                Optional biome;
                PlayerEntity player = (PlayerEntity)entity;
                if (player.func_233580_cy_().func_177956_o() <= 60) {
                    fogDensity += (float)(62 - player.func_233580_cy_().func_177956_o()) * 0.00333f;
                }
                if ((biome = world.func_242406_i(entity.func_233580_cy_())).isPresent() && biome.get() == AtumBiomes.OASIS) {
                    fogDensity /= 2.0f;
                }
                for (ItemStack armor : player.func_184193_aE()) {
                    if (!(armor.func_77973_b() instanceof IFogReductionItem)) continue;
                    EquipmentSlotType slotType = MobEntity.func_184640_d((ItemStack)armor);
                    IFogReductionItem fogReductionItem = (IFogReductionItem)armor.func_77973_b();
                    if (!fogReductionItem.getSlotTypes().contains(slotType)) continue;
                    fogDensity = fogReductionItem.getFogReduction(fogDensity, armor);
                }
                if (player.func_226278_cu_() >= 55.0) {
                    fogDensity *= 1.0f + sandstormFog - (sandstormFog - sandstormFog * SandstormHandler.INSTANCE.stormStrength);
                }
                RenderSystem.fogDensity((float)fogDensity);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public static void onRender(RenderPlayerEvent.Pre event) {
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio(AtumItems.NUITS_VANISHING, event.getEntityLiving());
        if (optional.isPresent() && !NuitsVanishingItem.TIMER.containsKey((Object)event.getEntityLiving()) && !NuitsVanishingItem.isLivingEntityMoving(event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderMummyHelmet(RenderGameOverlayEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        if (player != null && mc.field_71474_y.func_243230_g().func_243192_a() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == AtumItems.MUMMY_HELMET) {
            int width = mc.func_228018_at_().func_198107_o();
            int height = mc.func_228018_at_().func_198087_p();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            mc.func_110434_K().func_110577_a(MUMMY_BLUR_TEXTURE);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_225582_a_(0.0, (double)height, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)width, (double)height, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            bufferbuilder.func_225582_a_((double)width, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.enableAlphaTest();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

