/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class PapyrusBlock
extends SugarCaneBlock {
    private static final BooleanProperty TOP = BooleanProperty.func_177716_a((String)"top");

    public PapyrusBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176355_a, (Comparable)Integer.valueOf(0))).func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState soil = world.func_180495_p(pos.func_177977_b());
        Block block = soil.func_177230_c();
        if (block == this) {
            return true;
        }
        if (block == AtumBlocks.FERTILE_SOIL || block == AtumBlocks.FERTILE_SOIL_TILLED || block == AtumBlocks.SAND) {
            BlockPos powDown = pos.func_177977_b();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                FluidState fluidState = world.func_204610_c(powDown.func_177972_a(direction));
                if (!fluidState.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction direction, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == AtumBlocks.PAPYRUS && this == AtumBlocks.PAPYRUS) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(world.func_175623_d(pos.func_177984_a()))));
        if (world.func_180495_p(pos.func_177977_b()).equals(state.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(true)))) {
            world.func_175656_a(pos.func_177977_b(), (BlockState)state.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_175656_a(pos.func_177977_b(), (BlockState)state.func_206870_a((Property)TOP, (Comparable)Boolean.valueOf(world.func_175623_d(pos.func_177984_a()))));
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumItems.PAPYRUS_PLANT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{field_176355_a, TOP});
    }
}

