/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumParticles;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;

public class FertileSoilTilledBlock
extends FarmlandBlock {
    public static final BooleanProperty BLESSED = BooleanProperty.func_177716_a((String)"blessed");

    public FertileSoilTilledBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).harvestTool(ToolType.SHOVEL).harvestLevel(0).func_235847_c_(AtumBlocks::needsPostProcessing).func_235842_b_(AtumBlocks::needsPostProcessing));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(0))).func_206870_a((Property)BLESSED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return FarmlandBlock.field_196432_b;
    }

    public void func_225534_a_(BlockState state, @Nonnull ServerWorld serverWorld, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (!state.func_196955_c((IWorldReader)serverWorld, pos)) {
            FertileSoilTilledBlock.turnToSoil((World)serverWorld, pos, AtumBlocks.FERTILE_SOIL);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, @Nonnull Random rand) {
        int moisture = (Integer)state.func_177229_b((Property)field_176531_a);
        Block blockUp = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (((Boolean)state.func_177229_b((Property)BLESSED)).booleanValue() && blockUp instanceof IGrowable) {
            world.func_205220_G_().func_205360_a(pos.func_177984_a(), (Object)blockUp, 5);
        }
        if (!this.hasWater((World)world, pos) && !world.func_175727_C(pos.func_177984_a())) {
            if (moisture > 0) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!this.hasCrops((World)world, pos)) {
                FertileSoilTilledBlock.turnToSoil((World)world, pos, AtumBlocks.FERTILE_SOIL);
            }
        } else if (moisture < 7) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)field_176531_a) > 0 || (Boolean)state.func_177229_b((Property)BLESSED) != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (((Boolean)state.func_177229_b((Property)BLESSED)).booleanValue() && !world.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)world, pos.func_177984_a()) && rand.nextDouble() <= 0.15) {
            double d0 = rand.nextGaussian() * 0.01;
            double d1 = rand.nextGaussian() * 0.005;
            double d2 = rand.nextGaussian() * 0.01;
            world.func_195594_a((IParticleData)AtumParticles.TEFNUT, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + 1.05, (double)((float)pos.func_177952_p() + rand.nextFloat()), d0, d1, d2);
        }
    }

    public void func_180658_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity entity, float fallDistance) {
        if (!world.field_72995_K && entity.canTrample(this.func_176223_P(), pos, fallDistance)) {
            FertileSoilTilledBlock.turnToSoil(world, pos, AtumBlocks.FERTILE_SOIL);
        }
        entity.func_225503_b_(fallDistance, 1.0f);
    }

    private static void turnToSoil(World world, BlockPos pos, Block block) {
        world.func_175656_a(pos, FertileSoilTilledBlock.func_199601_a((BlockState)world.func_180495_p(pos), (BlockState)block.func_176223_P(), (World)world, (BlockPos)pos));
    }

    private boolean hasCrops(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(world.func_180495_p(pos), (IBlockReader)world, pos, Direction.UP, (IPlantable)block);
    }

    private boolean hasWater(World world, BlockPos pos) {
        for (BlockPos mutablePos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-6, 0, -6), (BlockPos)pos.func_177982_a(6, 1, 6))) {
            if (!world.func_180495_p(mutablePos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return false;
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            FertileSoilTilledBlock.turnToSoil(world, pos, AtumBlocks.SAND);
        }
    }

    public void onPlantGrow(BlockState state, @Nonnull IWorld world, @Nonnull BlockPos pos, BlockPos source) {
        if (this == AtumBlocks.FERTILE_SOIL_TILLED) {
            world.func_180501_a(pos, AtumBlocks.FERTILE_SOIL.func_176223_P(), 2);
        }
        super.onPlantGrow(state, world, pos, source);
    }

    public void func_220082_b(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, world, pos, oldState, isMoving);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            FertileSoilTilledBlock.turnToSoil(world, pos, AtumBlocks.SAND);
        }
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction direction, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        if (plantType.equals(PlantType.CROP) || plantType.equals(PlantType.PLAINS)) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{field_176531_a, BLESSED});
    }
}

